/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import java.util.Collection;
import mpicbg.models.AbstractAffineModel3D;
import mpicbg.models.InvertibleBoundable;
import mpicbg.models.NoninvertibleModelException;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.PointMatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranslationModel3D
extends AbstractAffineModel3D<TranslationModel3D>
implements InvertibleBoundable {
    private static final long serialVersionUID = 2917354712492515946L;
    protected static final int MIN_NUM_MATCHES = 1;
    protected final double[] translation = new double[3];

    @Override
    public final int getMinNumMatches() {
        return 1;
    }

    public final double[] getTranslation() {
        return this.translation;
    }

    @Override
    public final double[] apply(double[] point) {
        assert (point.length >= 3) : "3d translations can be applied to 3d points only.";
        return new double[]{point[0] + this.translation[0], point[1] + this.translation[1], point[2] + this.translation[2]};
    }

    @Override
    public final void applyInPlace(double[] point) {
        assert (point.length >= 3) : "3d translations can be applied to 3d points only.";
        point[0] = point[0] + this.translation[0];
        point[1] = point[1] + this.translation[1];
        point[2] = point[2] + this.translation[2];
    }

    @Override
    public final double[] applyInverse(double[] point) {
        assert (point.length >= 3) : "3d translations can be applied to 3d points only.";
        return new double[]{point[0] - this.translation[0], point[1] - this.translation[1], point[2] - this.translation[2]};
    }

    @Override
    public final void applyInverseInPlace(double[] point) {
        assert (point.length >= 3) : "3d translations can be applied to 3d points only.";
        point[0] = point[0] - this.translation[0];
        point[1] = point[1] - this.translation[1];
        point[2] = point[2] - this.translation[2];
    }

    public final String toString() {
        return "[1,3](" + this.translation[0] + "," + this.translation[1] + "," + this.translation[2] + ") " + this.cost;
    }

    @Override
    public final <P extends PointMatch> void fit(Collection<P> matches) throws NotEnoughDataPointsException {
        if (matches.size() < 1) {
            throw new NotEnoughDataPointsException(matches.size() + " data points are not enough to estimate a 3d translation model, at least " + 1 + " data points required.");
        }
        double pcx = 0.0;
        double pcy = 0.0;
        double pcz = 0.0;
        double qcx = 0.0;
        double qcy = 0.0;
        double qcz = 0.0;
        double ws = 0.0;
        for (PointMatch m : matches) {
            double[] p = m.getP1().getL();
            double[] q = m.getP2().getW();
            double w = m.getWeight();
            ws += w;
            pcx += w * p[0];
            pcy += w * p[1];
            pcz += w * p[2];
            qcx += w * q[0];
            qcy += w * q[1];
            qcz += w * q[2];
        }
        this.translation[0] = (qcx /= ws) - (pcx /= ws);
        this.translation[1] = (qcy /= ws) - (pcy /= ws);
        this.translation[2] = (qcz /= ws) - (pcz /= ws);
    }

    public final void set(double tx, double ty, double tz) {
        this.translation[0] = tx;
        this.translation[1] = ty;
        this.translation[2] = tz;
    }

    @Override
    public final void set(TranslationModel3D m) {
        this.translation[0] = m.translation[0];
        this.translation[1] = m.translation[1];
        this.translation[2] = m.translation[2];
        this.cost = m.getCost();
    }

    @Override
    public TranslationModel3D copy() {
        TranslationModel3D m = new TranslationModel3D();
        m.translation[0] = this.translation[0];
        m.translation[1] = this.translation[1];
        m.translation[2] = this.translation[2];
        m.cost = this.cost;
        return m;
    }

    @Override
    public TranslationModel3D createInverse() {
        TranslationModel3D ict = new TranslationModel3D();
        ict.translation[0] = -this.translation[0];
        ict.translation[1] = -this.translation[1];
        ict.translation[2] = -this.translation[2];
        ict.cost = this.cost;
        return ict;
    }

    @Override
    public void estimateBounds(double[] min, double[] max) {
        this.applyInPlace(min);
        this.applyInPlace(max);
    }

    @Override
    public void estimateInverseBounds(double[] min, double[] max) throws NoninvertibleModelException {
        this.applyInverseInPlace(min);
        this.applyInverseInPlace(max);
    }

    @Override
    public void preConcatenate(TranslationModel3D model) {
        this.concatenate(model);
    }

    @Override
    public void concatenate(TranslationModel3D model) {
        this.translation[0] = this.translation[0] + model.translation[0];
        this.translation[1] = this.translation[1] + model.translation[1];
        this.translation[2] = this.translation[2] + model.translation[2];
    }

    @Override
    public void toArray(double[] data) {
        data[0] = 1.0;
        data[1] = 0.0;
        data[2] = 0.0;
        data[3] = 0.0;
        data[4] = 1.0;
        data[5] = 0.0;
        data[6] = 0.0;
        data[7] = 0.0;
        data[8] = 1.0;
        data[9] = this.translation[0];
        data[10] = this.translation[1];
        data[11] = this.translation[2];
    }

    @Override
    public double[] getMatrix(double[] m) {
        double[] a = m == null || m.length != 12 ? new double[12] : m;
        a[0] = 1.0;
        a[1] = 0.0;
        a[2] = 0.0;
        a[3] = this.translation[0];
        a[4] = 0.0;
        a[5] = 1.0;
        a[6] = 0.0;
        a[7] = this.translation[1];
        a[8] = 0.0;
        a[9] = 0.0;
        a[10] = 1.0;
        a[11] = this.translation[2];
        return a;
    }

    @Override
    public void toMatrix(double[][] data) {
        data[0][0] = 1.0;
        data[0][1] = 0.0;
        data[0][2] = 0.0;
        data[0][3] = this.translation[0];
        data[1][0] = 0.0;
        data[1][1] = 1.0;
        data[1][2] = 0.0;
        data[1][3] = this.translation[1];
        data[2][0] = 0.0;
        data[2][1] = 0.0;
        data[2][2] = 1.0;
        data[2][3] = this.translation[2];
    }
}

