/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import mpicbg.models.AbstractMovingLeastSquaresTransform;
import mpicbg.models.IllDefinedDataPointsException;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.PointMatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MovingLeastSquaresTransform
extends AbstractMovingLeastSquaresTransform {
    private static final long serialVersionUID = -8566403075161793547L;
    protected final Set<PointMatch> matches = new HashSet<PointMatch>();

    public final Set<PointMatch> getMatches() {
        return this.matches;
    }

    @Override
    public final void setMatches(Collection<PointMatch> matches) throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        this.matches.clear();
        this.matches.addAll(matches);
        this.model.fit(matches);
    }

    @Override
    public void applyInPlace(double[] location) {
        ArrayList<PointMatch> weightedMatches = new ArrayList<PointMatch>();
        for (PointMatch m : this.matches) {
            double[] l = m.getP1().getL();
            double s = 0.0;
            for (int i = 0; i < location.length; ++i) {
                double dx = l[i] - location[i];
                s += dx * dx;
            }
            if (s <= 0.0) {
                double[] w = m.getP2().getW();
                for (int i = 0; i < location.length; ++i) {
                    location[i] = w[i];
                }
                return;
            }
            double weight = m.getWeight() * this.weigh(s);
            PointMatch mw = new PointMatch(m.getP1(), m.getP2(), weight);
            weightedMatches.add(mw);
        }
        try {
            this.model.fit(weightedMatches);
            this.model.applyInPlace(location);
        }
        catch (IllDefinedDataPointsException e) {
        }
        catch (NotEnoughDataPointsException notEnoughDataPointsException) {
            // empty catch block
        }
    }
}

