/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import mpicbg.models.InverseBoundable;
import mpicbg.models.InverseCoordinateTransform;
import mpicbg.models.NoninvertibleModelException;
import mpicbg.models.TransformList;
import mpicbg.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InverseCoordinateTransformList<E extends InverseCoordinateTransform>
implements InverseBoundable,
TransformList<E> {
    private static final long serialVersionUID = -3077711542359109619L;
    private final List<E> transforms = new ArrayList();

    @Override
    public final void add(E t) {
        this.transforms.add(t);
    }

    @Override
    public final void remove(E t) {
        this.transforms.remove(t);
    }

    @Override
    public final E remove(int i) {
        return (E)((InverseCoordinateTransform)this.transforms.remove(i));
    }

    @Override
    public final E get(int i) {
        return (E)((InverseCoordinateTransform)this.transforms.get(i));
    }

    @Override
    public final void clear() {
        this.transforms.clear();
    }

    @Override
    public final List<E> getList(List<E> preAllocatedList) {
        ArrayList<E> returnList = preAllocatedList == null ? new ArrayList<E>() : preAllocatedList;
        returnList.addAll(this.transforms);
        return returnList;
    }

    @Override
    public final double[] applyInverse(double[] location) throws NoninvertibleModelException {
        double[] a = (double[])location.clone();
        this.applyInverseInPlace(a);
        return a;
    }

    @Override
    public final void applyInverseInPlace(double[] location) throws NoninvertibleModelException {
        ListIterator<E> i = this.transforms.listIterator(this.transforms.size());
        while (i.hasPrevious()) {
            ((InverseCoordinateTransform)i.previous()).applyInverseInPlace(location);
        }
    }

    @Override
    public void estimateInverseBounds(double[] min, double[] max) throws NoninvertibleModelException {
        assert (min.length == max.length) : "min and max have to have equal length.";
        int g = 32;
        double[] minBounds = new double[min.length];
        double[] maxBounds = new double[min.length];
        double[] s = new double[min.length];
        int[] i = new int[min.length];
        double[] l = new double[min.length];
        for (int k = 0; k < min.length; ++k) {
            minBounds[k] = Double.MAX_VALUE;
            maxBounds[k] = -1.7976931348623157E308;
            s[k] = (max[k] - min[k]) / 31.0;
            l[k] = min[k];
        }
        long d = Util.pow(32, min.length);
        block1: for (long j = 0L; j < d; ++j) {
            int k;
            double[] m = this.applyInverse(l);
            for (k = 0; k < min.length; ++k) {
                if (m[k] < minBounds[k]) {
                    minBounds[k] = m[k];
                }
                if (!(m[k] > maxBounds[k])) continue;
                maxBounds[k] = m[k];
            }
            for (k = 0; k < min.length; ++k) {
                int n = k;
                i[n] = i[n] + 1;
                if (i[k] < 32) {
                    l[k] = min[k] + (double)i[k] * s[k];
                    continue block1;
                }
                i[k] = 0;
                l[k] = min[k];
            }
        }
        for (int k = 0; k < min.length; ++k) {
            min[k] = minBounds[k];
            max[k] = maxBounds[k];
        }
    }
}

