/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imagefeatures;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import mpicbg.imagefeatures.Feature;
import mpicbg.imagefeatures.Filter;
import mpicbg.imagefeatures.FloatArray2D;
import mpicbg.imagefeatures.FloatArray2DFeatureTransform;
import mpicbg.imagefeatures.FloatArray2DScaleOctave;
import mpicbg.imagefeatures.FloatArray2DScaleOctaveDoGDetector;
import mpicbg.models.AbstractModel;
import mpicbg.models.Point;
import mpicbg.models.PointMatch;
import mpicbg.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatArray2DMOPS
extends FloatArray2DFeatureTransform<Param> {
    private float[] sigma;
    private float[] sigma_diff;
    private float[][] kernel_diff;
    final int O_SCALE = 4;
    final int O_SCALE_LD2 = 2;
    private FloatArray2DScaleOctave[] octaves = null;
    private final FloatArray2DScaleOctaveDoGDetector dog = new FloatArray2DScaleOctaveDoGDetector();
    public FloatArray2D pattern;

    public long getFeatureObjectSize() {
        return FloatArray2DMOPS.getFeatureObjectSize(((Param)this.p).fdSize);
    }

    public static long getFeatureObjectSize(int fdsize) {
        return fdsize * fdsize * 4 + 32 + 32;
    }

    public FloatArray2DScaleOctave[] getOctaves() {
        return this.octaves;
    }

    public FloatArray2DScaleOctave getOctave(int i) {
        return this.octaves[i];
    }

    public FloatArray2DMOPS(Param p) {
        super(p);
        this.sigma = new float[p.steps + 3];
        this.sigma[0] = p.initialSigma;
        this.sigma_diff = new float[p.steps + 3];
        this.sigma_diff[0] = 0.0f;
        this.kernel_diff = new float[p.steps + 3][];
        for (int i = 1; i < p.steps + 3; ++i) {
            this.sigma[i] = (float)((double)p.initialSigma * Math.pow(2.0, (double)i / (double)p.steps));
            this.sigma_diff[i] = (float)Math.sqrt(this.sigma[i] * this.sigma[i] - p.initialSigma * p.initialSigma);
            this.kernel_diff[i] = Filter.createGaussianKernel(this.sigma_diff[i], true);
        }
    }

    @Override
    public void init(FloatArray2D src) {
        int o = 0;
        double w = src.width;
        double h = src.height;
        int minOctaveSize = ((Param)this.p).minOctaveSize / 4;
        int max_kernel_size = this.kernel_diff[((Param)this.p).steps + 2].length;
        while (w > (double)Math.max(max_kernel_size, minOctaveSize - 1) && h > (double)Math.max(max_kernel_size, minOctaveSize - 1)) {
            w /= 2.0;
            h /= 2.0;
            ++o;
        }
        this.octaves = new FloatArray2DScaleOctave[o];
        for (int i = 0; i < this.octaves.length; ++i) {
            this.octaves[i] = new FloatArray2DScaleOctave(src, this.sigma, this.sigma_diff, this.kernel_diff);
            this.octaves[i].buildStub();
            FloatArray2D next = new FloatArray2D(src.width / 2 + src.width % 2, src.height / 2 + src.height % 2);
            FloatArray2DScaleOctave.downsample(this.octaves[i].getL(1), next);
            if (src.width > ((Param)this.p).maxOctaveSize || src.height > ((Param)this.p).maxOctaveSize) {
                this.octaves[i].clear();
            }
            src = next;
        }
    }

    private float[] createDescriptor(double[] c, int o, double octave_sigma, double orientation) {
        FloatArray2DScaleOctave octave = this.octaves[o + 2];
        FloatArray2D l = octave.getL((int)Math.round(c[2]));
        float[] desc = new float[((Param)this.p).fdSize * ((Param)this.p).fdSize];
        double cos_o = Math.cos(orientation);
        double sin_o = Math.sin(orientation);
        int i = 0;
        float max = Float.MIN_VALUE;
        float min = Float.MAX_VALUE;
        for (int y = ((Param)this.p).fdSize - 1; y >= 0; --y) {
            double ys = ((double)y - (double)((Param)this.p).fdSize / 2.0 + 0.5) * octave_sigma;
            for (int x = ((Param)this.p).fdSize - 1; x >= 0; --x) {
                double xs = ((double)x - (double)((Param)this.p).fdSize / 2.0 + 0.5) * octave_sigma;
                double yr = cos_o * ys + sin_o * xs;
                double xr = cos_o * xs - sin_o * ys;
                int yg = Util.pingPong((int)Math.round(yr + c[1] / 4.0), l.height);
                int xg = Util.pingPong((int)Math.round(xr + c[0] / 4.0), l.width);
                desc[i] = l.get(xg, yg);
                if (desc[i] > max) {
                    max = desc[i];
                } else if (desc[i] < min) {
                    min = desc[i];
                }
                ++i;
            }
        }
        float n = max - min;
        for (i = 0; i < desc.length; ++i) {
            desc[i] = (desc[i] - min) / n;
        }
        return desc;
    }

    void processCandidate(double[] c, int o, List<Feature> features) {
        int i;
        int ORIENTATION_BINS = 36;
        double ORIENTATION_BIN_SIZE = 0.17453292519943295;
        float[] histogram_bins = new float[36];
        int scale = 1 << o;
        FloatArray2DScaleOctave octave = this.octaves[o];
        double octave_sigma = (double)octave.SIGMA[0] * Math.pow(2.0, c[2] / (double)octave.STEPS);
        FloatArray2D gaussianMask = Filter.createGaussianKernelOffset(octave_sigma * 1.5, c[0] - Math.floor(c[0]), c[1] - Math.floor(c[1]), false);
        FloatArray2D[] src = octave.getL1((int)Math.round(c[2]));
        FloatArray2D[] gradientROI = new FloatArray2D[]{new FloatArray2D(gaussianMask.width, gaussianMask.width), new FloatArray2D(gaussianMask.width, gaussianMask.width)};
        int half_size = gaussianMask.width / 2;
        int n = gaussianMask.width * gaussianMask.width - 1;
        for (int yi = gaussianMask.width - 1; yi >= 0; --yi) {
            int ra_y = src[0].width * Math.max(0, Math.min(src[0].height - 1, (int)c[1] + yi - half_size));
            int ra_x = ra_y + Math.min((int)c[0], src[0].width - 1);
            for (int xi = gaussianMask.width - 1; xi >= 0; --xi) {
                int pt = Math.max(ra_y, Math.min(ra_y + src[0].width - 2, ra_x + xi - half_size));
                gradientROI[0].data[n] = src[0].data[pt];
                gradientROI[1].data[n] = src[1].data[pt];
                --n;
            }
        }
        for (i = 0; i < gradientROI[0].data.length; ++i) {
            int n2 = i;
            gradientROI[0].data[n2] = gradientROI[0].data[n2] * gaussianMask.data[i];
        }
        for (i = 0; i < gradientROI[0].data.length; ++i) {
            int bin;
            int n3 = bin = Math.max(0, (int)(((double)gradientROI[1].data[i] + Math.PI) / 0.17453292519943295));
            histogram_bins[n3] = histogram_bins[n3] + gradientROI[0].data[i];
        }
        int max_i = 0;
        for (int i2 = 0; i2 < 36; ++i2) {
            if (!(histogram_bins[i2] > histogram_bins[max_i])) continue;
            max_i = i2;
        }
        double e0 = histogram_bins[(max_i + 36 - 1) % 36];
        double e1 = histogram_bins[max_i];
        double e2 = histogram_bins[(max_i + 1) % 36];
        double offset = (e0 - e2) / 2.0 / (e0 - 2.0 * e1 + e2);
        double orientation = ((double)max_i + offset) * 0.17453292519943295 - Math.PI;
        features.add(new Feature(octave_sigma * (double)scale, orientation, new double[]{c[0] * (double)scale, c[1] * (double)scale}, this.createDescriptor(c, o, octave_sigma, orientation)));
        for (int i3 = 0; i3 < 36; ++i3) {
            if (i3 == max_i || (max_i + 1) % 36 == i3 || (max_i - 1 + 36) % 36 == i3 || !((double)histogram_bins[i3] > 0.8 * (double)histogram_bins[max_i])) continue;
            e0 = histogram_bins[(i3 + 36 - 1) % 36];
            e1 = histogram_bins[i3];
            e2 = histogram_bins[(i3 + 1) % 36];
            if (!(e0 < e1) || !(e2 < e1)) continue;
            offset = (e0 - e2) / 2.0 / (e0 - 2.0 * e1 + e2);
            orientation = ((double)i3 + 0.5 + offset) * 0.17453292519943295 - Math.PI;
            features.add(new Feature(octave_sigma * (double)scale, orientation, new double[]{c[0] * (double)scale, c[1] * (double)scale}, this.createDescriptor(c, o, octave_sigma, orientation)));
        }
    }

    public List<Feature> runOctave(int o) {
        ArrayList<Feature> features = new ArrayList<Feature>();
        FloatArray2DScaleOctave octave = this.octaves[o];
        octave.build();
        this.dog.run(octave);
        Vector<double[]> candidates = this.dog.getCandidates();
        for (double[] c : candidates) {
            this.processCandidate(c, o, features);
        }
        return features;
    }

    public List<Feature> run() {
        int o;
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (o = 0; o < this.octaves.length; ++o) {
            if (this.octaves[o].state == FloatArray2DScaleOctave.State.EMPTY) continue;
            this.octaves[o].build();
        }
        for (o = 0; o < this.octaves.length - 2; ++o) {
            if (this.octaves[o].state == FloatArray2DScaleOctave.State.EMPTY) continue;
            List<Feature> more = this.runOctave(o);
            features.addAll(more);
        }
        return features;
    }

    public List<Feature> run(int max_size) {
        int o;
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (o = 0; o < this.octaves.length; ++o) {
            if (this.octaves[o].width > max_size || this.octaves[o].height > max_size) continue;
            this.octaves[o].build();
        }
        for (o = 0; o < this.octaves.length - 2; ++o) {
            if (this.octaves[o].width > max_size || this.octaves[o].height > max_size) continue;
            List<Feature> more = this.runOctave(o);
            features.addAll(more);
        }
        return features;
    }

    public static List<PointMatch> createMatches(List<Feature> fs1, List<Feature> fs2, float rod) {
        ArrayList<PointMatch> matches = new ArrayList<PointMatch>();
        for (Feature f1 : fs1) {
            Feature best = null;
            double best_d = Double.MAX_VALUE;
            double second_best_d = Double.MAX_VALUE;
            for (Feature f2 : fs2) {
                double d = f1.descriptorDistance(f2);
                if (d < best_d) {
                    second_best_d = best_d;
                    best_d = d;
                    best = f2;
                    continue;
                }
                if (!(d < second_best_d)) continue;
                second_best_d = d;
            }
            if (best == null || !(second_best_d < Double.MAX_VALUE) || !(best_d / second_best_d < (double)rod)) continue;
            matches.add(new PointMatch(new Point(new double[]{f1.location[0], f1.location[1]}), new Point(new double[]{best.location[0], best.location[1]}), (f1.scale + best.scale) / 2.0));
        }
        int i = 0;
        while (i < matches.size()) {
            boolean amb = false;
            PointMatch m = (PointMatch)matches.get(i);
            double[] m_p2 = m.getP2().getL();
            int j = i + 1;
            while (j < matches.size()) {
                PointMatch n = (PointMatch)matches.get(j);
                double[] n_p2 = n.getP2().getL();
                if (m_p2[0] == n_p2[0] && m_p2[1] == n_p2[1]) {
                    amb = true;
                    matches.remove(j);
                    continue;
                }
                ++j;
            }
            if (amb) {
                matches.remove(i);
                continue;
            }
            ++i;
        }
        return matches;
    }

    public static List<PointMatch> createMatches(List<Feature> fs1, List<Feature> fs2, double rod, HashMap<Point, Feature> m1, HashMap<Point, Feature> m2) {
        ArrayList<PointMatch> matches = new ArrayList<PointMatch>();
        for (Feature f1 : fs1) {
            Feature best = null;
            double best_d = Double.MAX_VALUE;
            double second_best_d = Double.MAX_VALUE;
            for (Feature f2 : fs2) {
                double d = f1.descriptorDistance(f2);
                if (d < best_d) {
                    second_best_d = best_d;
                    best_d = d;
                    best = f2;
                    continue;
                }
                if (!(d < second_best_d)) continue;
                second_best_d = d;
            }
            if (best == null || !(second_best_d < Double.MAX_VALUE) || !(best_d / second_best_d < rod)) continue;
            Point p1 = new Point(new double[]{f1.location[0], f1.location[1]});
            Point p2 = new Point(new double[]{best.location[0], best.location[1]});
            matches.add(new PointMatch(p1, p2, (f1.scale + best.scale) / 2.0));
            m1.put(p1, f1);
            m2.put(p2, best);
        }
        int i = 0;
        while (i < matches.size()) {
            boolean amb = false;
            PointMatch m = (PointMatch)matches.get(i);
            double[] m_p2 = m.getP2().getL();
            int j = i + 1;
            while (j < matches.size()) {
                PointMatch n = (PointMatch)matches.get(j);
                double[] n_p2 = n.getP2().getL();
                if (m_p2[0] == n_p2[0] && m_p2[1] == n_p2[1]) {
                    m1.remove(n.getP1());
                    m2.remove(n.getP2());
                    amb = true;
                    matches.remove(j);
                    continue;
                }
                ++j;
            }
            if (amb) {
                matches.remove(i);
                m1.remove(m.getP1());
                m2.remove(m.getP2());
                continue;
            }
            ++i;
        }
        return matches;
    }

    public static List<PointMatch> createMatches(List<Feature> fs1, List<Feature> fs2, double max_sd, AbstractModel<?> model, double max_id, double rod) {
        ArrayList<PointMatch> matches = new ArrayList<PointMatch>();
        double min_sd = 1.0 / max_sd;
        int size = fs2.size();
        int size_1 = size - 1;
        for (Feature f1 : fs1) {
            Feature best = null;
            double best_d = Double.MAX_VALUE;
            double second_best_d = Double.MAX_VALUE;
            int first = 0;
            int last = size_1;
            int s = size / 2 + size % 2;
            if (max_sd < Double.MAX_VALUE) {
                while (s > 1) {
                    Feature f2 = fs2.get(last);
                    last = f2.scale / f1.scale < min_sd ? Math.max(0, last - s) : Math.min(size_1, last + s);
                    f2 = fs2.get(first);
                    first = f2.scale / f1.scale < max_sd ? Math.max(0, first - s) : Math.min(size_1, first + s);
                    s = s / 2 + s % 2;
                }
            }
            for (int i = first; i <= last; ++i) {
                Feature f2 = fs2.get(i);
                double d = f1.descriptorDistance(f2);
                if (d < best_d) {
                    second_best_d = best_d;
                    best_d = d;
                    best = f2;
                    continue;
                }
                if (!(d < second_best_d)) continue;
                second_best_d = d;
            }
            if (best == null || !(second_best_d < Double.MAX_VALUE) || !(best_d / second_best_d < rod)) continue;
            matches.add(new PointMatch(new Point(new double[]{f1.location[0], f1.location[1]}), new Point(new double[]{best.location[0], best.location[1]}), (f1.scale + best.scale) / 2.0));
        }
        int i = 0;
        while (i < matches.size()) {
            boolean amb = false;
            PointMatch m = (PointMatch)matches.get(i);
            double[] m_p2 = m.getP2().getL();
            int j = i + 1;
            while (j < matches.size()) {
                PointMatch n = (PointMatch)matches.get(j);
                double[] n_p2 = n.getP2().getL();
                if (m_p2[0] == n_p2[0] && m_p2[1] == n_p2[1]) {
                    amb = true;
                    matches.remove(j);
                    continue;
                }
                ++j;
            }
            if (amb) {
                matches.remove(i);
                continue;
            }
            ++i;
        }
        return matches;
    }

    @Override
    public final void extractFeatures(Collection<Feature> features) {
        features.addAll(this.run(((Param)this.p).maxOctaveSize));
    }

    public static double[] featureSizeHistogram(List<Feature> features, double min, double max, int bins) {
        System.out.print("estimating feature size histogram ...");
        int num_features = features.size();
        double[] h = new double[bins];
        int[] hb = new int[bins];
        for (Feature f : features) {
            int bin;
            int n = bin = Math.max(0, Math.min(bins - 1, (int)(Math.log(f.scale) / Math.log(2.0) * 28.0)));
            hb[n] = hb[n] + 1;
        }
        for (int i = 0; i < bins; ++i) {
            h[i] = (double)hb[i] / (double)num_features;
        }
        System.out.println(" done");
        return h;
    }

    public final float getInitialSigma() {
        return ((Param)this.p).initialSigma;
    }

    public final void setInitialSigma(float initialSigma) {
        ((Param)this.p).initialSigma = initialSigma;
        this.sigma = new float[((Param)this.p).steps + 3];
        this.sigma[0] = ((Param)this.p).initialSigma;
        this.sigma_diff = new float[((Param)this.p).steps + 3];
        this.sigma_diff[0] = 0.0f;
        this.kernel_diff = new float[((Param)this.p).steps + 3][];
        for (int i = 1; i < ((Param)this.p).steps + 3; ++i) {
            this.sigma[i] = (float)((double)((Param)this.p).initialSigma * Math.pow(2.0, (double)i / (double)((Param)this.p).steps));
            this.sigma_diff[i] = (float)Math.sqrt(this.sigma[i] * this.sigma[i] - ((Param)this.p).initialSigma * ((Param)this.p).initialSigma);
            this.kernel_diff[i] = Filter.createGaussianKernel(this.sigma_diff[i], true);
        }
    }

    public final int getMaxOctaveSize() {
        return ((Param)this.p).maxOctaveSize;
    }

    public static final class Param {
        public int fdSize = 16;
        public int maxOctaveSize = 1024;
        public int minOctaveSize = 64;
        public int steps = 3;
        public float initialSigma = 1.6f;
    }
}

