/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imagefeatures;

import mpicbg.imagefeatures.FloatArray2D;
import mpicbg.util.Util;

public class Filter {
    public static final double[] createGaussianKernel(double sigma, boolean normalize) {
        double[] kernel;
        if (sigma <= 0.0) {
            kernel = new double[3];
            kernel[1] = 1.0;
        } else {
            int size = Math.max(3, 2 * (int)(3.0 * sigma + 0.5) + 1);
            double two_sq_sigma = 2.0 * sigma * sigma;
            kernel = new double[size];
            for (int x = size / 2; x >= 0; --x) {
                double val;
                kernel[size / 2 - x] = val = Math.exp((double)(-(x * x)) / two_sq_sigma);
                kernel[size / 2 + x] = val;
            }
        }
        if (normalize) {
            double sum = 0.0;
            for (double value : kernel) {
                sum += value;
            }
            int i = 0;
            while (i < kernel.length) {
                int n = i++;
                kernel[n] = kernel[n] / sum;
            }
        }
        return kernel;
    }

    public static final float[] createGaussianKernel(float sigma, boolean normalize) {
        float[] kernel;
        if (sigma <= 0.0f) {
            kernel = new float[3];
            kernel[1] = 1.0f;
        } else {
            int size = Math.max(3, 2 * (int)((double)(3.0f * sigma) + 0.5) + 1);
            float two_sq_sigma = 2.0f * sigma * sigma;
            kernel = new float[size];
            for (int x = size / 2; x >= 0; --x) {
                float val;
                kernel[size / 2 - x] = val = (float)Math.exp(-((float)(x * x)) / two_sq_sigma);
                kernel[size / 2 + x] = val;
            }
        }
        if (normalize) {
            float sum = 0.0f;
            for (float value : kernel) {
                sum += value;
            }
            int i = 0;
            while (i < kernel.length) {
                int n = i++;
                kernel[n] = kernel[n] / sum;
            }
        }
        return kernel;
    }

    public static final FloatArray2D createGaussianKernelOffset(float sigma, float offset_x, float offset_y, boolean normalize) {
        FloatArray2D kernel;
        if (sigma == 0.0f) {
            kernel = new FloatArray2D(3, 3);
            kernel.data[4] = 1.0f;
        } else {
            int size = Math.max(3, 2 * Math.round(3.0f * sigma) + 1);
            float two_sq_sigma = 2.0f * sigma * sigma;
            kernel = new FloatArray2D(size, size);
            for (int x = size - 1; x >= 0; --x) {
                float fx = x - size / 2;
                for (int y = size - 1; y >= 0; --y) {
                    float fy = y - size / 2;
                    float val = (float)Math.exp(-(Math.pow(fx - offset_x, 2.0) + Math.pow(fy - offset_y, 2.0)) / (double)two_sq_sigma);
                    kernel.set(val, x, y);
                }
            }
        }
        if (normalize) {
            float sum = 0.0f;
            for (float value : kernel.data) {
                sum += value;
            }
            int i = 0;
            while (i < kernel.data.length) {
                int n = i++;
                kernel.data[n] = kernel.data[n] / sum;
            }
        }
        return kernel;
    }

    public static final FloatArray2D createGaussianKernelOffset(double sigma, double offset_x, double offset_y, boolean normalize) {
        FloatArray2D kernel;
        if (sigma == 0.0) {
            kernel = new FloatArray2D(3, 3);
            kernel.data[4] = 1.0f;
        } else {
            int size = Math.max(3, (int)(2L * Math.round(3.0 * sigma) + 1L));
            double two_sq_sigma = 2.0 * sigma * sigma;
            kernel = new FloatArray2D(size, size);
            for (int x = size - 1; x >= 0; --x) {
                double fx = x - size / 2;
                for (int y = size - 1; y >= 0; --y) {
                    double fy = y - size / 2;
                    double val = Math.exp(-(Math.pow(fx - offset_x, 2.0) + Math.pow(fy - offset_y, 2.0)) / two_sq_sigma);
                    kernel.set((float)val, x, y);
                }
            }
        }
        if (normalize) {
            double sum = 0.0;
            for (float value : kernel.data) {
                sum += (double)value;
            }
            int i = 0;
            while (i < kernel.data.length) {
                int n = i++;
                kernel.data[n] = (float)((double)kernel.data[n] / sum);
            }
        }
        return kernel;
    }

    public static final FloatArray2D[] createGradients(FloatArray2D array) {
        FloatArray2D[] gradients = new FloatArray2D[]{new FloatArray2D(array.width, array.height), new FloatArray2D(array.width, array.height)};
        for (int y = 0; y < array.height; ++y) {
            int[] ro = new int[]{array.width * Math.max(0, y - 1), array.width * y, array.width * Math.min(y + 1, array.height - 1)};
            for (int x = 0; x < array.width; ++x) {
                float der_x = (array.data[ro[1] + Math.min(x + 1, array.width - 1)] - array.data[ro[1] + Math.max(0, x - 1)]) / 2.0f;
                float der_y = (array.data[ro[2] + x] - array.data[ro[0] + x]) / 2.0f;
                gradients[0].data[ro[1] + x] = (float)Math.sqrt(Math.pow(der_x, 2.0) + Math.pow(der_y, 2.0));
                gradients[1].data[ro[1] + x] = (float)Math.atan2(der_y, der_x);
            }
        }
        return gradients;
    }

    public static final void enhance(FloatArray2D src, float scale) {
        float min;
        float max = min = src.data[0];
        for (float f : src.data) {
            if (f < min) {
                min = f;
                continue;
            }
            if (!(f > max)) continue;
            max = f;
        }
        float s = scale / (max - min);
        for (int i = 0; i < src.data.length; ++i) {
            src.data[i] = s * (src.data[i] - min);
        }
    }

    public static final FloatArray2D convolveSeparable(FloatArray2D input, float[] h, float[] v) {
        FloatArray2D output = new FloatArray2D(input.width, input.height);
        FloatArray2D temp = new FloatArray2D(input.width, input.height);
        int hl = h.length / 2;
        int vl = v.length / 2;
        int xl = input.width - h.length + 1;
        int yl = input.height - v.length + 1;
        int[] xb = new int[h.length + hl - 1];
        int[] xa = new int[h.length + hl - 1];
        for (int i = 0; i < xb.length; ++i) {
            xb[i] = Util.pingPong(i - hl, input.width);
            xa[i] = Util.pingPong(i + xl, input.width);
        }
        int[] yb = new int[v.length + vl - 1];
        int[] ya = new int[v.length + vl - 1];
        for (int i = 0; i < yb.length; ++i) {
            yb[i] = input.width * Util.pingPong(i - vl, input.height);
            ya[i] = input.width * Util.pingPong(i + yl, input.height);
        }
        xl += hl;
        yl += vl;
        int rl = input.height * input.width;
        for (int r = 0; r < rl; r += input.width) {
            int xk;
            int x;
            for (x = hl; x < xl; ++x) {
                int c = x - hl;
                float val = 0.0f;
                for (xk = 0; xk < h.length; ++xk) {
                    val += h[xk] * input.data[r + c + xk];
                }
                temp.data[r + x] = val;
            }
            for (x = 0; x < hl; ++x) {
                float valb = 0.0f;
                float vala = 0.0f;
                for (xk = 0; xk < h.length; ++xk) {
                    valb += h[xk] * input.data[r + xb[x + xk]];
                    vala += h[xk] * input.data[r + xa[x + xk]];
                }
                temp.data[r + x] = valb;
                temp.data[r + x + xl] = vala;
            }
        }
        int rm = yl * temp.width;
        int vlc = vl * temp.width;
        for (int x = 0; x < temp.width; ++x) {
            int yk;
            for (int r = vlc; r < rm; r += temp.width) {
                float val = 0.0f;
                int c = r - vlc;
                int rk = 0;
                for (yk = 0; yk < v.length; ++yk) {
                    val += v[yk] * temp.data[c + rk + x];
                    rk += temp.width;
                }
                output.data[r + x] = val;
            }
            for (int y = 0; y < vl; ++y) {
                int r = y * temp.width;
                float valb = 0.0f;
                float vala = 0.0f;
                for (yk = 0; yk < v.length; ++yk) {
                    valb += h[yk] * temp.data[yb[y + yk] + x];
                    vala += h[yk] * temp.data[ya[y + yk] + x];
                }
                output.data[r + x] = valb;
                output.data[r + rm + x] = vala;
            }
        }
        return output;
    }
}

