/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij.clahe;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.Roi;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Rectangle;
import java.util.ArrayList;
import mpicbg.ij.clahe.Apply;
import mpicbg.ij.clahe.ByteApply;
import mpicbg.ij.clahe.FastByteApply;
import mpicbg.ij.clahe.FastFlat;
import mpicbg.ij.clahe.FloatApply;
import mpicbg.ij.clahe.RGBApply;
import mpicbg.ij.clahe.ShortApply;
import mpicbg.ij.clahe.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Flat {
    private static final Flat instance = new Flat();
    private static final FastFlat fastInstance = new FastFlat();

    public static Flat getInstance() {
        return instance;
    }

    public static FastFlat getFastInstance() {
        return fastInstance;
    }

    @Deprecated
    public static void run(ImagePlus imp, int blockRadius, int bins, float slope, ByteProcessor mask) {
        Flat.getInstance().run(imp, blockRadius, bins, slope, mask, true);
    }

    public final void run(ImagePlus imp, int blockRadius, int bins, float slope, ByteProcessor mask, boolean composite) {
        Roi roi = imp.getRoi();
        if (roi == null) {
            this.run(imp, blockRadius, bins, slope, null, mask, composite);
        } else {
            Rectangle roiBox = roi.getBounds();
            ImageProcessor roiMask = roi.getMask();
            if (mask != null) {
                Rectangle oldRoi = mask.getRoi();
                mask.setRoi(roi);
                ByteProcessor cropMask = (ByteProcessor)mask.crop().convertToByte(true);
                if (roiMask != null) {
                    byte[] roiMaskPixels = (byte[])roiMask.getPixels();
                    byte[] cropMaskPixels = (byte[])cropMask.getPixels();
                    for (int i = 0; i < roiMaskPixels.length; ++i) {
                        cropMaskPixels[i] = (byte)mpicbg.util.Util.roundPos((float)((cropMaskPixels[i] & 0xFF) * (roiMaskPixels[i] & 0xFF)) / 255.0f);
                    }
                }
                this.run(imp, blockRadius, bins, slope, roiBox, cropMask, composite);
                mask.setRoi(oldRoi);
            } else if (roiMask == null) {
                this.run(imp, blockRadius, bins, slope, roiBox, null, composite);
            } else {
                this.run(imp, blockRadius, bins, slope, roiBox, (ByteProcessor)roiMask.convertToByte(false), composite);
            }
        }
    }

    public final void run(ImagePlus imp, int blockRadius, int bins, float slope, Rectangle roiBox, ByteProcessor mask, boolean composite) {
        ImageProcessor ip;
        composite &= imp.getNChannels() > 1;
        Rectangle box = roiBox == null ? (mask == null ? new Rectangle(0, 0, imp.getWidth(), imp.getHeight()) : new Rectangle(0, 0, Math.min(imp.getWidth(), mask.getWidth()), Math.min(imp.getHeight(), mask.getHeight()))) : roiBox;
        if (mask != null) {
            box.width = Math.min(mask.getWidth(), box.width);
            box.height = Math.min(mask.getHeight(), box.height);
        }
        box.width = Math.min(imp.getWidth() - box.x, box.width);
        box.height = Math.min(imp.getHeight() - box.y, box.height);
        int boxXMax = box.x + box.width;
        int boxYMax = box.y + box.height;
        if (imp.getType() == 3) {
            ip = imp.getProcessor().convertToRGB();
            imp.setProcessor(imp.getTitle(), ip);
        } else {
            ip = imp.getProcessor();
        }
        ByteProcessor src = composite ? (ByteProcessor)new ColorProcessor(imp.getImage()).convertToByte(true) : (imp.getType() == 0 ? (ByteProcessor)ip.convertToByte(true).duplicate() : (ByteProcessor)ip.convertToByte(true));
        ByteProcessor dst = (ByteProcessor)src.duplicate();
        ArrayList appliers = new ArrayList();
        try {
            if (composite) {
                block14: for (int n = 0; n < imp.getNChannels(); ++n) {
                    int channelIndex = imp.getStackIndex(n + 1, imp.getSlice(), imp.getFrame());
                    ImageProcessor cp = imp.getStack().getProcessor(channelIndex);
                    switch (imp.getType()) {
                        case 0: {
                            appliers.add(new ByteApply((ByteProcessor)cp, src, dst, mask, box.x, box.y, boxXMax, boxYMax));
                            continue block14;
                        }
                        case 1: {
                            appliers.add(new ShortApply((ShortProcessor)cp, src, dst, mask, box.x, box.y, boxXMax, boxYMax));
                            continue block14;
                        }
                        case 2: {
                            appliers.add(new FloatApply((FloatProcessor)cp, src, dst, mask, box.x, box.y, boxXMax, boxYMax));
                            continue block14;
                        }
                        case 4: {
                            appliers.add(new RGBApply((ColorProcessor)cp, src, dst, mask, box.x, box.y, boxXMax, boxYMax));
                        }
                    }
                }
            } else {
                switch (imp.getType()) {
                    case 0: {
                        appliers.add(new FastByteApply((ByteProcessor)ip, src, dst, mask, box.x, box.y, boxXMax, boxYMax));
                        break;
                    }
                    case 1: {
                        appliers.add(new ShortApply((ShortProcessor)ip, src, dst, mask, box.x, box.y, boxXMax, boxYMax));
                        break;
                    }
                    case 2: {
                        appliers.add(new FloatApply((FloatProcessor)ip, src, dst, mask, box.x, box.y, boxXMax, boxYMax));
                        break;
                    }
                    case 4: {
                        appliers.add(new RGBApply((ColorProcessor)ip, src, dst, mask, box.x, box.y, boxXMax, boxYMax));
                    }
                }
            }
        }
        catch (Exception e) {
            IJ.error((String)e.getMessage());
            return;
        }
        this.run(imp, blockRadius, bins, slope, box.x, box.y, boxXMax, boxYMax, src, dst, mask, ip, composite, appliers);
    }

    protected void run(ImagePlus imp, int blockRadius, int bins, float slope, int boxXMin, int boxYMin, int boxXMax, int boxYMax, ByteProcessor src, ByteProcessor dst, ByteProcessor mask, ImageProcessor ip, boolean composite, ArrayList<Apply<?>> appliers) {
        boolean updatePerRow = imp.isVisible();
        for (int y = boxYMin; y < boxYMax; ++y) {
            int yMin = Math.max(0, y - blockRadius);
            int yMax = Math.min(imp.getHeight(), y + blockRadius + 1);
            int h = yMax - yMin;
            int xMin0 = Math.max(0, boxXMin - blockRadius - 1);
            int xMax0 = Math.min(imp.getWidth() - 1, boxXMin + blockRadius);
            int[] hist = new int[bins + 1];
            int[] clippedHist = new int[bins + 1];
            for (int yi = yMin; yi < yMax; ++yi) {
                for (int xi = xMin0; xi < xMax0; ++xi) {
                    int n = mpicbg.util.Util.roundPos((float)src.get(xi, yi) / 255.0f * (float)bins);
                    hist[n] = hist[n] + 1;
                }
            }
            for (int x = boxXMin; x < boxXMax; ++x) {
                int yi;
                int v = mpicbg.util.Util.roundPos((float)src.get(x, y) / 255.0f * (float)bins);
                int xMin = Math.max(0, x - blockRadius);
                int xMax = x + blockRadius + 1;
                int w = Math.min(imp.getWidth(), xMax) - xMin;
                int n = h * w;
                int limit = mask == null ? (int)(slope * (float)n / (float)bins + 0.5f) : (int)((1.0f + (float)mask.get(x - boxXMin, y - boxYMin) / 255.0f * (slope - 1.0f)) * (float)n / (float)bins + 0.5f);
                if (xMin > 0) {
                    int xMin1 = xMin - 1;
                    for (yi = yMin; yi < yMax; ++yi) {
                        int n2 = mpicbg.util.Util.roundPos((float)src.get(xMin1, yi) / 255.0f * (float)bins);
                        hist[n2] = hist[n2] - 1;
                    }
                }
                if (xMax <= imp.getWidth()) {
                    int xMax1 = xMax - 1;
                    for (yi = yMin; yi < yMax; ++yi) {
                        int n3 = mpicbg.util.Util.roundPos((float)src.get(xMax1, yi) / 255.0f * (float)bins);
                        hist[n3] = hist[n3] + 1;
                    }
                }
                dst.set(x, y, mpicbg.util.Util.roundPos(Util.transferValue(v, hist, clippedHist, limit) * 255.0f));
            }
            if (!updatePerRow) continue;
            for (Apply<?> apply : appliers) {
                apply.apply(boxXMin, y, boxXMax, y + 1);
            }
            imp.updateAndDraw();
        }
        if (!updatePerRow) {
            for (Apply<?> apply : appliers) {
                apply.apply(boxXMin, boxYMin, boxXMax, boxYMax);
            }
            imp.updateAndDraw();
        }
    }
}

