/*
 * Decompiled with CFR 0.152.
 */
package io.scif.jj2000.j2k.image.input;

import io.scif.jj2000.j2k.JJ2KExceptionHandler;
import io.scif.jj2000.j2k.image.DataBlk;
import io.scif.jj2000.j2k.image.DataBlkInt;
import io.scif.jj2000.j2k.image.input.ImgReader;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class ImgReaderPGM
extends ImgReader {
    public static int DC_OFFSET = 128;
    private RandomAccessFile in;
    private int offset;
    private int rb;
    private byte[] buf;
    private DataBlkInt intBlk;

    public ImgReaderPGM(File file) throws IOException {
        this(new RandomAccessFile(file, "r"));
    }

    public ImgReaderPGM(String fname) throws IOException {
        this(new RandomAccessFile(fname, "r"));
    }

    public ImgReaderPGM(RandomAccessFile in) throws EOFException, IOException {
        this.in = in;
        this.confirmFileType();
        this.skipCommentAndWhiteSpace();
        this.w = this.readHeaderInt();
        this.skipCommentAndWhiteSpace();
        this.h = this.readHeaderInt();
        this.skipCommentAndWhiteSpace();
        this.readHeaderInt();
        this.nc = 1;
        this.rb = 8;
    }

    public void close() throws IOException {
        this.in.close();
        this.in = null;
    }

    public int getNomRangeBits(int c) {
        if (c != 0) {
            throw new IllegalArgumentException();
        }
        return this.rb;
    }

    public int getFixedPoint(int c) {
        if (c != 0) {
            throw new IllegalArgumentException();
        }
        return 0;
    }

    public final DataBlk getInternCompData(DataBlk blk, int c) {
        int[] barr;
        if (c != 0) {
            throw new IllegalArgumentException();
        }
        if (blk.getDataType() != 3) {
            if (this.intBlk == null) {
                this.intBlk = new DataBlkInt(blk.ulx, blk.uly, blk.w, blk.h);
            } else {
                this.intBlk.ulx = blk.ulx;
                this.intBlk.uly = blk.uly;
                this.intBlk.w = blk.w;
                this.intBlk.h = blk.h;
            }
            blk = this.intBlk;
        }
        if ((barr = (int[])blk.getData()) == null || barr.length < blk.w * blk.h) {
            barr = new int[blk.w * blk.h];
            blk.setData(barr);
        }
        if (this.buf == null || this.buf.length < blk.w) {
            this.buf = new byte[blk.w];
        }
        try {
            int mi = blk.uly + blk.h;
            for (int i = blk.uly; i < mi; ++i) {
                this.in.seek(this.offset + i * this.w + blk.ulx);
                this.in.read(this.buf, 0, blk.w);
                int k = (i - blk.uly) * blk.w + blk.w - 1;
                int j = blk.w - 1;
                while (j >= 0) {
                    barr[k] = (this.buf[j] & 0xFF) - DC_OFFSET;
                    --j;
                    --k;
                }
            }
        }
        catch (IOException e) {
            JJ2KExceptionHandler.handleException(e);
        }
        blk.progressive = false;
        blk.offset = 0;
        blk.scanw = blk.w;
        return blk;
    }

    public DataBlk getCompData(DataBlk blk, int c) {
        return this.getInternCompData(blk, c);
    }

    private byte countedByteRead() throws IOException, EOFException {
        ++this.offset;
        return this.in.readByte();
    }

    private void confirmFileType() throws IOException, EOFException {
        byte[] type = new byte[]{80, 53};
        for (int i = 0; i < 2; ++i) {
            byte b = this.countedByteRead();
            if (b == type[i]) continue;
            if (i == 1 && b == 50) {
                throw new IllegalArgumentException("JJ2000 does not support ascii-PGM files. Use  raw-PGM file instead. ");
            }
            throw new IllegalArgumentException("Not a raw-PGM file");
        }
    }

    private void skipCommentAndWhiteSpace() throws IOException, EOFException {
        boolean done = false;
        while (!done) {
            byte b = this.countedByteRead();
            if (b == 35) {
                while (b != 10 && b != 13) {
                    b = this.countedByteRead();
                }
                continue;
            }
            if (b == 9 || b == 10 || b == 13 || b == 32) continue;
            done = true;
        }
        --this.offset;
        this.in.seek(this.offset);
    }

    private int readHeaderInt() throws IOException, EOFException {
        int res = 0;
        byte b = 0;
        b = this.countedByteRead();
        while (b != 32 && b != 10 && b != 9 && b != 13) {
            res = res * 10 + b - 48;
            b = this.countedByteRead();
        }
        return res;
    }

    public boolean isOrigSigned(int c) {
        if (c != 0) {
            throw new IllegalArgumentException();
        }
        return false;
    }

    public String toString() {
        return "ImgReaderPGM: WxH = " + this.w + "x" + this.h + ", Component = 0" + "\nUnderlying RandomAccessIO:\n" + this.in.toString();
    }
}

