/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugins.scripting.jython;

import java.io.Reader;
import java.io.Writer;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import org.python.core.Py;
import org.python.core.PyCode;
import org.python.core.PyObject;
import org.python.util.PythonInterpreter;
import org.scijava.plugins.scripting.jython.JythonBindings;
import org.scijava.script.AbstractScriptEngine;

public class JythonScriptEngine
extends AbstractScriptEngine {
    protected final PythonInterpreter interpreter = new PythonInterpreter();

    public JythonScriptEngine() {
        this.engineScopeBindings = new JythonBindings(this.interpreter);
    }

    public Object eval(String script) throws ScriptException {
        this.setup();
        try {
            return this.interpreter.eval(script);
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
    }

    public Object eval(Reader reader) throws ScriptException {
        this.setup();
        try {
            String filename = this.getString("javax.script.filename");
            return Py.runCode((PyCode)this.interpreter.compile(reader, filename), null, (PyObject)this.interpreter.getLocals());
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
    }

    protected void setup() {
        Writer errorWriter;
        Writer writer;
        ScriptContext context = this.getContext();
        Reader reader = context.getReader();
        if (reader != null) {
            this.interpreter.setIn(reader);
        }
        if ((writer = context.getWriter()) != null) {
            this.interpreter.setOut(writer);
        }
        if ((errorWriter = context.getErrorWriter()) != null) {
            this.interpreter.setErr(errorWriter);
        }
    }

    private String getString(String key) {
        Object result = this.get(key);
        return result == null ? null : result.toString();
    }
}

