/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugins.scripting.jython;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import org.python.core.PyStringMap;
import org.python.util.PythonInterpreter;
import org.scijava.plugins.scripting.jython.JythonScriptEngine;
import org.scijava.script.ScriptModule;

public class JythonBindings
implements Bindings {
    protected final PythonInterpreter interpreter;
    private final Map<String, WeakReference<Object>> shallowMap = new HashMap<String, WeakReference<Object>>();

    public JythonBindings(PythonInterpreter interpreter) {
        this.interpreter = interpreter;
    }

    @Override
    public int size() {
        return this.interpreter.getLocals().__len__();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        for (Object value2 : this.values()) {
            if (!value.equals(value2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object get(Object key) {
        if (this.shallowMap.containsKey(key)) {
            return this.shallowMap.get(key).get();
        }
        try {
            return this.interpreter.get((String)key);
        }
        catch (Error e) {
            return null;
        }
    }

    @Override
    public Object put(String key, Object value) {
        Object result = this.get(key);
        if (value instanceof ScriptModule || value instanceof JythonScriptEngine) {
            this.shallowMap.put(key, new WeakReference<Object>(value));
        } else {
            try {
                this.interpreter.set(key, value);
            }
            catch (Error error) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public Object remove(Object key) {
        Object result = this.get(key);
        if (this.shallowMap.containsKey(key)) {
            this.shallowMap.remove(key);
        } else if (result != null) {
            this.interpreter.getLocals().__delitem__((String)key);
        }
        return result;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> toMerge) {
        for (Map.Entry<? extends String, ? extends Object> entry : toMerge.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    private PyStringMap dict() {
        return (PyStringMap)this.interpreter.getLocals();
    }

    @Override
    public void clear() {
        this.dict().clear();
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> result = new HashSet<String>();
        for (Object name : this.dict().keys()) {
            result.add(name.toString());
        }
        return result;
    }

    @Override
    public Collection<Object> values() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object name : this.dict().keys()) {
            try {
                result.add(this.get(name));
            }
            catch (Error error) {}
        }
        return result;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashSet<Map.Entry<String, Object>> result = new HashSet<Map.Entry<String, Object>>();
        for (final Object name : this.dict().keys()) {
            result.add(new Map.Entry<String, Object>(){

                @Override
                public String getKey() {
                    return name.toString();
                }

                @Override
                public Object getValue() {
                    return JythonBindings.this.get(name);
                }

                @Override
                public Object setValue(Object value) {
                    throw new UnsupportedOperationException();
                }
            });
        }
        return result;
    }
}

