/*
 * Decompiled with CFR 0.152.
 */
package io.scif.refs;

import io.scif.refs.CleaningRef;
import io.scif.refs.RefManagerService;
import io.scif.refs.RefProvider;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.plugin.PluginService;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;
import org.scijava.thread.ThreadService;

@Plugin(type=Service.class)
public class DefaultRefManagerService
extends AbstractService
implements RefManagerService {
    @Parameter
    private ThreadService threadService;
    @Parameter
    private PluginService pluginService;
    @Parameter
    private LogService logService;
    private final boolean[] disposed = new boolean[1];
    private final Map<Object, Set<Class<?>>> managed = new WeakHashMap();
    private final Set<Reference> knownRefs = new HashSet<Reference>();
    private ReferenceQueue queue;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void manage(Object toManage, Object ... params) {
        for (RefProvider refProvider : this.pluginService.createInstancesOfType(RefProvider.class)) {
            if (this.isManaged(toManage, refProvider.getClass()) || !refProvider.handles(toManage, params)) continue;
            Reference ref = refProvider.makeRef(toManage, this.queue, params);
            Object object = this.managed;
            synchronized (object) {
                Set<Class<?>> refs = this.managed.get(toManage);
                if (refs == null) {
                    refs = new HashSet();
                    this.managed.put(toManage, refs);
                }
                refs.add(ref.getClass());
            }
            object = this.knownRefs;
            synchronized (object) {
                this.knownRefs.add(ref);
                if (this.knownRefs.size() == 1) {
                    this.threadService.run((Runnable)new RefCleaner(this.queue, this.knownRefs, this.logService, this.disposed));
                }
            }
        }
    }

    public void dispose() {
        this.disposed[0] = false;
    }

    public void initialize() {
        this.queue = new ReferenceQueue();
        this.disposed[0] = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isManaged(Object referent, Class<?> pClass) {
        Map<Object, Set<Class<?>>> map = this.managed;
        synchronized (map) {
            Set<Class<?>> refs = this.managed.get(referent);
            if (refs != null && refs.contains(pClass)) {
                return true;
            }
        }
        return false;
    }

    private static class RefCleaner
    implements Runnable {
        private final ReferenceQueue queue;
        private final Set<Reference> refs;
        private final LogService logService;
        private final boolean[] run;

        public RefCleaner(ReferenceQueue queue, Set<Reference> refs, LogService log, boolean[] runFlag) {
            this.queue = queue;
            this.refs = refs;
            this.logService = log;
            this.run = runFlag;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int size = this.refs.size();
            while (size > 0 && this.run[0]) {
                CleaningRef cleaningRef = null;
                try {
                    cleaningRef = (CleaningRef)((Object)this.queue.remove(50L));
                }
                catch (InterruptedException e) {
                    this.logService.error((Object)"RefCleaner: interrupted while polling queue", (Throwable)e);
                }
                Set<Reference> e = this.refs;
                synchronized (e) {
                    if (cleaningRef != null) {
                        cleaningRef.cleanup();
                        this.refs.remove(cleaningRef);
                    }
                    size = this.refs.size();
                }
            }
            if (!this.run[0]) {
                for (Reference ref : this.refs) {
                    CleaningRef cleaningRef = (CleaningRef)((Object)ref);
                    cleaningRef.cleanup();
                }
            }
        }
    }
}

