/*
 * Decompiled with CFR 0.152.
 */
package io.scif.io;

import io.scif.AbstractSCIFIOPlugin;
import io.scif.services.LocationService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.scijava.Context;
import org.scijava.plugin.Parameter;

public class Location
extends AbstractSCIFIOPlugin {
    private static final String URL_REGEX = "^([a-z]{1,7}:){1,2}//[-a-zA-Z0-9+&@#/%$'?=~_|!:,.;]+";
    private static final Pattern urlPattern = Pattern.compile("^([a-z]{1,7}:){1,2}//[-a-zA-Z0-9+&@#/%$'?=~_|!:,.;]+");
    @Parameter
    private LocationService locationService;
    private boolean isURL = true;
    private URL url;
    private File file;

    public Location(Context context) {
        this.setContext(context);
    }

    public Location(Context context, String pathname) {
        this(context);
        this.log().trace((Object)("Location(" + pathname + ")"));
        Matcher m = urlPattern.matcher(pathname);
        if (m.find()) {
            try {
                this.url = new URL(this.locationService.getMappedId(pathname));
            }
            catch (MalformedURLException e) {
                this.log().trace((Object)"Location is not a URL", (Throwable)e);
                this.isURL = false;
            }
        } else {
            this.isURL = false;
        }
        if (!this.isURL) {
            this.file = new File(this.locationService.getMappedId(pathname));
        }
    }

    public Location(Context context, File file) {
        this(context);
        this.log().trace((Object)("Location(" + file + ")"));
        this.isURL = false;
        this.file = file;
    }

    public Location(Context context, String parent, String child) {
        this(context, parent + File.separator + child);
    }

    public Location(Context context, Location parent, String child) {
        this(context, parent.getAbsolutePath(), child);
    }

    public String[] list(boolean noHiddenFiles) {
        String path = this.getAbsolutePath();
        String key = path + Boolean.toString(noHiddenFiles);
        String[] result = null;
        result = this.locationService.getCachedListing(key);
        if (result != null) {
            return result;
        }
        ArrayList<String> files = new ArrayList<String>();
        if (this.isURL) {
            try {
                URLConnection c = this.url.openConnection();
                InputStream is = c.getInputStream();
                boolean foundEnd = false;
                while (!foundEnd) {
                    int ndx;
                    int idx;
                    byte[] b = new byte[is.available()];
                    is.read(b);
                    String s = new String(b, "UTF-8");
                    if (s.toLowerCase().contains("</html>")) {
                        foundEnd = true;
                    }
                    while (s.contains("a href") && (idx = s.indexOf("\"", ndx = s.indexOf("a href") + 8)) >= 0) {
                        Location check;
                        String f = s.substring(ndx, idx);
                        if (files.size() > 0 && f.startsWith("/")) {
                            return null;
                        }
                        s = s.substring(idx + 1);
                        if (f.startsWith("?") || !(check = new Location(this.getContext(), path, f)).exists() || noHiddenFiles && check.isHidden()) continue;
                        files.add(check.getName());
                    }
                }
            }
            catch (IOException e) {
                this.log().trace((Object)"Could not retrieve directory listing", (Throwable)e);
                return null;
            }
        } else {
            if (this.file == null) {
                return null;
            }
            String[] f = this.file.list();
            if (f == null) {
                return null;
            }
            for (String name : f) {
                if (noHiddenFiles && (name.startsWith(".") || new Location(this.getContext(), path, name).isHidden())) continue;
                files.add(name);
            }
        }
        if (files.size() == 0) {
            return null;
        }
        result = files.toArray(new String[files.size()]);
        this.locationService.putCachedListing(key, result);
        return result;
    }

    public boolean canRead() {
        return this.isURL ? this.isDirectory() || this.isFile() : this.file.canRead();
    }

    public boolean canWrite() {
        return this.isURL ? false : this.file.canWrite();
    }

    public boolean createNewFile() throws IOException {
        if (this.isURL) {
            throw new IOException("Unimplemented");
        }
        return this.file.createNewFile();
    }

    public boolean delete() {
        return this.isURL ? false : this.file.delete();
    }

    public void deleteOnExit() {
        if (!this.isURL) {
            this.file.deleteOnExit();
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        String absPath = this.getAbsolutePath();
        String thatPath = obj instanceof Location ? ((Location)obj).getAbsolutePath() : obj.toString();
        return absPath.equals(thatPath);
    }

    public int hashCode() {
        return this.getAbsolutePath().hashCode();
    }

    public boolean exists() {
        if (this.isURL) {
            try {
                this.url.getContent();
                return true;
            }
            catch (IOException e) {
                this.log().trace((Object)"Failed to retrieve content from URL", (Throwable)e);
                return false;
            }
        }
        if (this.file.exists()) {
            return true;
        }
        if (this.locationService.getMappedFile(this.file.getPath()) != null) {
            return true;
        }
        String mappedId = this.locationService.getMappedId(this.file.getPath());
        return mappedId != null && new File(mappedId).exists();
    }

    public Location getAbsoluteFile() {
        return new Location(this.getContext(), this.getAbsolutePath());
    }

    public String getAbsolutePath() {
        return this.isURL ? this.url.toExternalForm() : this.file.getAbsolutePath();
    }

    public Location getCanonicalFile() throws IOException {
        return this.isURL ? this.getAbsoluteFile() : new Location(this.getContext(), this.file.getCanonicalFile());
    }

    public String getCanonicalPath() throws IOException {
        return this.isURL ? this.getAbsolutePath() : this.file.getCanonicalPath();
    }

    public String getName() {
        if (this.isURL) {
            String name = this.url.getFile();
            name = name.substring(name.lastIndexOf("/") + 1);
            return name;
        }
        return this.file.getName();
    }

    public String getParent() {
        if (this.isURL) {
            String absPath = this.getAbsolutePath();
            absPath = absPath.substring(0, absPath.lastIndexOf("/"));
            return absPath;
        }
        return this.file.getParent();
    }

    public Location getParentFile() {
        return new Location(this.getContext(), this.getParent());
    }

    public String getPath() {
        return this.isURL ? this.url.getHost() + this.url.getPath() : this.file.getPath();
    }

    public boolean isAbsolute() {
        return this.isURL ? true : this.file.isAbsolute();
    }

    public boolean isDirectory() {
        if (this.isURL) {
            String[] list = this.list();
            return list != null;
        }
        return this.file.isDirectory();
    }

    public boolean isFile() {
        return this.isURL ? !this.isDirectory() && this.exists() : this.file.isFile();
    }

    public boolean isHidden() {
        return this.isURL ? false : this.file.getName().startsWith(".");
    }

    public long lastModified() {
        if (this.isURL) {
            try {
                return this.url.openConnection().getLastModified();
            }
            catch (IOException e) {
                this.log().trace((Object)"Could not determine URL's last modification time", (Throwable)e);
                return 0L;
            }
        }
        return this.file.lastModified();
    }

    public long length() {
        if (this.isURL) {
            try {
                return this.url.openConnection().getContentLength();
            }
            catch (IOException e) {
                this.log().trace((Object)"Could not determine URL's content length", (Throwable)e);
                return 0L;
            }
        }
        return this.file.length();
    }

    public String[] list() {
        return this.list(false);
    }

    public Location[] listFiles() {
        String[] s = this.list();
        String path = this.getAbsolutePath();
        if (s == null) {
            return null;
        }
        Location[] f = new Location[s.length];
        for (int i = 0; i < f.length; ++i) {
            f[i] = new Location(this.getContext(), path, s[i]);
            f[i] = f[i].getAbsoluteFile();
        }
        return f;
    }

    public URL toURL() throws MalformedURLException {
        return this.isURL ? this.url : this.file.toURI().toURL();
    }

    public String toString() {
        return this.isURL ? this.url.toString() : this.file.toString();
    }
}

