/*
 * Decompiled with CFR 0.152.
 */
package io.scif.io;

import io.scif.io.HandleException;
import io.scif.io.IStreamAccess;
import io.scif.io.StreamHandle;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import org.scijava.Context;
import org.scijava.plugin.Plugin;
import org.scijava.util.Bytes;

@Plugin(type=IStreamAccess.class)
public class GZipHandle
extends StreamHandle {
    public GZipHandle() {
    }

    public GZipHandle(Context context) {
        super(context);
    }

    public GZipHandle(Context context, String file) throws IOException {
        super(context);
        this.setFile(file);
    }

    @Override
    public boolean isConstructable(String file) throws IOException {
        if (!file.toLowerCase().endsWith(".gz")) {
            return false;
        }
        FileInputStream s = new FileInputStream(file);
        byte[] b = new byte[2];
        s.read(b);
        s.close();
        return Bytes.toInt((byte[])b, (boolean)true) == 35615;
    }

    @Override
    public void resetStream() throws IOException {
        if (this.getStream() != null) {
            this.getStream().close();
        }
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(this.getFile()), 0x100000);
        this.setStream(new DataInputStream(new GZIPInputStream(bis)));
    }

    @Override
    public void setFile(String file) throws IOException {
        int skip;
        super.setFile(file);
        if (!this.isConstructable(file)) {
            throw new HandleException(file + " is not a gzip file.");
        }
        this.resetStream();
        int length = 0;
        while ((skip = this.getStream().skipBytes(1024)) > 0) {
            length += skip;
        }
        this.setLength(length);
        this.resetStream();
    }
}

