/*
 * Decompiled with CFR 0.152.
 */
package io.scif.img.cell.loaders;

import io.scif.FormatException;
import io.scif.Metadata;
import io.scif.Plane;
import io.scif.Reader;
import io.scif.img.ImageRegion;
import io.scif.img.ImgUtilityService;
import io.scif.img.Range;
import io.scif.img.cell.loaders.SCIFIOArrayLoader;
import io.scif.util.FormatTools;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.imagej.axis.CalibratedAxis;
import net.imglib2.display.ColorTable;
import net.imglib2.type.numeric.RealType;
import org.scijava.plugin.Parameter;

public abstract class AbstractArrayLoader<A>
implements SCIFIOArrayLoader<A> {
    private int index = 0;
    private final Reader reader;
    private final ImageRegion subRegion;
    private final boolean compatible;
    @Parameter
    private ImgUtilityService imgUtilityService;
    private List<List<ColorTable>> tables;
    private boolean[][] loadedTable;

    public AbstractArrayLoader(Reader reader, ImageRegion subRegion) {
        this.reader = reader;
        this.subRegion = subRegion;
        reader.getContext().inject((Object)this);
        RealType<?> inputType = this.imgUtilityService.makeType(reader.getMetadata().get(0).getPixelType());
        this.compatible = this.outputClass().isAssignableFrom(inputType.getClass());
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public ColorTable loadTable(int imageIndex, int planeIndex) throws FormatException, IOException {
        ColorTable ct = this.getTable(imageIndex, planeIndex);
        if (ct == null && !this.loadedTable()[imageIndex][planeIndex]) {
            long[] planeMin = new long[this.reader.getMetadata().get(imageIndex).getAxesPlanar().size()];
            long[] planeMax = new long[planeMin.length];
            for (int i = 0; i < planeMax.length; ++i) {
                planeMax[i] = 1L;
            }
            ct = this.reader.openPlane(imageIndex, (long)planeIndex, planeMin, planeMax).getColorTable();
            this.addTable(imageIndex, planeIndex, ct);
        }
        return ct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public A loadArray(int[] dimensions, long[] min) {
        Reader reader = this.reader;
        synchronized (reader) {
            int index;
            Metadata meta = this.reader.getMetadata();
            int entities = 1;
            long[] planarMin = new long[meta.get(0).getAxesPlanar().size()];
            long[] planarLength = new long[meta.get(0).getAxesPlanar().size()];
            Range[] npRanges = new Range[meta.get(0).getAxesNonPlanar().size()];
            long[] npIndices = new long[npRanges.length];
            int axisIndex = 0;
            for (CalibratedAxis axis : meta.get(0).getAxesPlanar()) {
                index = meta.get(0).getAxisIndex(axis.type());
                if (index < dimensions.length) {
                    planarMin[axisIndex] = min[index];
                    planarLength[axisIndex] = dimensions[index];
                } else {
                    planarLength[axisIndex] = 1L;
                }
                entities = (int)((long)entities * planarLength[axisIndex]);
                ++axisIndex;
            }
            axisIndex = 0;
            for (CalibratedAxis axis : meta.get(0).getAxesNonPlanar()) {
                index = meta.get(0).getAxisIndex(axis.type());
                npRanges[axisIndex] = new Range(min[index], min[index] + (long)dimensions[index] - 1L);
                entities = this.subRegion != null ? (entities *= this.subRegion.getRange(axis.type()).size()) : (entities *= npRanges[axisIndex].size());
                ++axisIndex;
            }
            A data = null;
            data = this.emptyArray(entities);
            try {
                this.read(data, planarMin, planarLength, npRanges, npIndices);
            }
            catch (FormatException e) {
                throw new IllegalStateException("Could not open a plane for the given dimensions", e);
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not open a plane for the given dimensions", e);
            }
            return data;
        }
    }

    private void read(A data, long[] planarMin, long[] planarLength, Range[] npRanges, long[] npIndices) throws FormatException, IOException {
        this.read(data, null, planarMin, planarLength, npRanges, npIndices, 0, 0);
    }

    private void read(A data, Plane tmpPlane, long[] planarMin, long[] planarLength, Range[] npRanges, long[] npIndices, int depth, int planeCount) throws FormatException, IOException {
        if (depth < npRanges.length) {
            int npPosition = npRanges.length - 1 - depth;
            for (int i = 0; i < npRanges[npPosition].size(); ++i) {
                npIndices[npPosition] = (Long)npRanges[npPosition].get(i);
                this.read(data, tmpPlane, planarMin, planarLength, npRanges, npIndices, depth + 1, planeCount);
                ++planeCount;
            }
        } else if (this.inSubregion(npIndices)) {
            int planeIndex = (int)FormatTools.positionToRaster(0, this.reader, npIndices);
            tmpPlane = tmpPlane == null ? this.reader.openPlane(this.index, (long)planeIndex, planarMin, planarLength) : this.reader.openPlane(this.index, (long)planeIndex, tmpPlane, planarMin, planarLength);
            this.convertBytes(data, tmpPlane.getBytes(), planeCount);
            if (!this.loadedTable()[this.index][planeIndex]) {
                this.addTable(this.index, planeIndex, tmpPlane.getColorTable());
            }
        }
    }

    private boolean[][] loadedTable() {
        if (this.loadedTable == null) {
            Metadata m = this.reader.getMetadata();
            this.loadedTable = new boolean[m.getImageCount()][(int)m.get(0).getPlaneCount()];
        }
        return this.loadedTable;
    }

    private List<List<ColorTable>> tables() {
        if (this.tables == null) {
            this.tables = new ArrayList<List<ColorTable>>();
        }
        return this.tables;
    }

    private ColorTable getTable(int imageIndex, int planeIndex) {
        List<ColorTable> imageTable;
        List<List<ColorTable>> tables = this.tables();
        if (imageIndex >= tables.size()) {
            for (int i = tables.size(); i <= imageIndex; ++i) {
                tables.add(new ArrayList());
            }
        }
        return planeIndex >= (imageTable = tables.get(imageIndex)).size() ? null : imageTable.get(planeIndex);
    }

    private void addTable(int imageIndex, int planeIndex, ColorTable colorTable) {
        ColorTable ct = this.getTable(imageIndex, planeIndex);
        if (ct == null) {
            List<ColorTable> imageTable = this.tables.get(imageIndex);
            if (imageTable.size() <= planeIndex) {
                for (int i = imageTable.size(); i <= planeIndex; ++i) {
                    imageTable.add(null);
                }
            }
            boolean[][] isLoaded = this.loadedTable();
            isLoaded[imageIndex][planeIndex] = true;
            imageTable.set(planeIndex, colorTable);
        }
    }

    private boolean inSubregion(long[] npIndices) {
        boolean inSubregion = true;
        if (this.subRegion != null) {
            int index = 0;
            for (CalibratedAxis axis : this.reader.getMetadata().get(0).getAxesNonPlanar()) {
                inSubregion = inSubregion && this.inRange(this.subRegion.getRange(axis.type()), npIndices[index++]);
            }
        }
        return inSubregion;
    }

    private boolean inRange(Range range, long value) {
        if (range == null) {
            return true;
        }
        return range.contains(value);
    }

    protected Reader reader() {
        return this.reader;
    }

    protected boolean isCompatible() {
        return this.compatible;
    }

    protected ImgUtilityService utils() {
        return this.imgUtilityService;
    }

    public abstract void convertBytes(A var1, byte[] var2, int var3);

    public abstract Class<?> outputClass();
}

