/*
 * Decompiled with CFR 0.152.
 */
package io.scif.img.cell;

import io.scif.FormatException;
import io.scif.Reader;
import io.scif.img.cell.SCIFIOCellImgFactory;
import io.scif.img.cell.loaders.SCIFIOArrayLoader;
import io.scif.refs.RefManagerService;
import java.io.IOException;
import net.imglib2.display.ColorTable;
import net.imglib2.img.cell.AbstractCell;
import net.imglib2.img.cell.AbstractCellImg;
import net.imglib2.img.cell.Cells;
import net.imglib2.type.NativeType;
import org.scijava.Disposable;

public class SCIFIOCellImg<T extends NativeType<T>, A, C extends AbstractCell<A>>
extends AbstractCellImg<T, A, C, SCIFIOCellImgFactory<T>>
implements Disposable {
    private final Reader reader;
    private SCIFIOArrayLoader<?> loader;

    public SCIFIOCellImg(SCIFIOCellImgFactory<T> factory, Cells<A, C> cells) {
        super(factory, cells);
        this.reader = factory.reader();
        ((RefManagerService)this.reader.getContext().getService(RefManagerService.class)).manage((Object)this, new Object[0]);
    }

    public ColorTable getColorTable(int imageIndex, int planeIndex) throws FormatException, IOException {
        if (this.loader != null) {
            return this.loader.loadTable(imageIndex, planeIndex);
        }
        long[] planeMin = new long[this.reader.getMetadata().get(imageIndex).getAxesPlanar().size()];
        long[] planeMax = new long[planeMin.length];
        for (int i = 0; i < planeMax.length; ++i) {
            planeMax[i] = 1L;
        }
        return this.reader.openPlane(imageIndex, (long)planeIndex, planeMin, planeMax).getColorTable();
    }

    public A update(Object cursor) {
        return (A)((AbstractCellImg.CellContainerSampler)cursor).getCell().getData();
    }

    public SCIFIOCellImgFactory<T> factory() {
        return (SCIFIOCellImgFactory)this.factory;
    }

    public Reader reader() {
        return this.reader;
    }

    public void setLoader(SCIFIOArrayLoader<?> loader) {
        this.loader = loader;
    }

    public SCIFIOCellImg<T, A, C> copy() {
        SCIFIOCellImg<NativeType, ?, ?> copy = this.factory().create(this.dimension, (NativeType)((NativeType)this.firstElement()).createVariable());
        super.copyDataTo(copy);
        return copy;
    }

    public void dispose() {
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

