/*
 * Decompiled with CFR 0.152.
 */
package io.scif;

import io.scif.DefaultMetaTable;
import io.scif.Field;
import io.scif.FieldPrinter;
import io.scif.ImageMetadata;
import io.scif.MetaTable;
import io.scif.util.FormatTools;
import io.scif.util.SCIFIOMetadataTools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.imagej.axis.Axes;
import net.imagej.axis.AxisType;
import net.imagej.axis.CalibratedAxis;
import org.scijava.util.ArrayUtils;

public abstract class AbstractImageMetadata
implements ImageMetadata {
    public static final long THUMBNAIL_DIMENSION = 128L;
    private List<CalibratedAxis> planarAxes;
    private List<CalibratedAxis> extendedAxes;
    private List<CalibratedAxis> effectiveAxes;
    @Field(label="thumbSizeX")
    private long thumbSizeX;
    @Field(label="thumbSizeY")
    private long thumbSizeY;
    @Field(label="pixelType")
    private int pixelType;
    @Field(label="bitsPerPixel")
    private int bitsPerPixel;
    @Field(label="dimTypes")
    private List<CalibratedAxis> axes = new ArrayList<CalibratedAxis>();
    @Field(label="dimLengths")
    private final HashMap<AxisType, Long> axisLengths = new HashMap();
    @Field(label="orderCertain")
    private boolean orderCertain;
    @Field(label="littleEndian")
    private boolean littleEndian;
    @Field(label="indexed")
    private boolean indexed;
    @Field(label="planarAxiscount")
    private int planarAxisCount = -1;
    @Field(label="interleavedAxisCount")
    private int interleavedAxisCount = -1;
    @Field(label="falseColor")
    private boolean falseColor = true;
    @Field(label="metadataComplete")
    private boolean metadataComplete;
    @Field(label="thumbnail")
    private boolean thumbnail;
    private String name;
    private MetaTable table;

    public AbstractImageMetadata() {
    }

    public AbstractImageMetadata(ImageMetadata copy) {
        this();
        this.copy(copy);
    }

    @Override
    public void setThumbSizeX(long thumbSizeX) {
        this.thumbSizeX = thumbSizeX;
    }

    @Override
    public void setThumbSizeY(long thumbSizeY) {
        this.thumbSizeY = thumbSizeY;
    }

    @Override
    public void setPixelType(int pixelType) {
        this.pixelType = pixelType;
    }

    @Override
    public void setBitsPerPixel(int bitsPerPixel) {
        this.bitsPerPixel = bitsPerPixel;
    }

    @Override
    public void setOrderCertain(boolean orderCertain) {
        this.orderCertain = orderCertain;
    }

    @Override
    public void setLittleEndian(boolean littleEndian) {
        this.littleEndian = littleEndian;
    }

    @Override
    public void setIndexed(boolean indexed) {
        this.indexed = indexed;
    }

    @Override
    public void setPlanarAxisCount(int count) {
        this.planarAxisCount = count;
        this.clearCachedAxes();
    }

    @Override
    public void setInterleavedAxisCount(int count) {
        this.interleavedAxisCount = count;
    }

    @Override
    public void setFalseColor(boolean falseColor) {
        this.falseColor = falseColor;
    }

    @Override
    public void setMetadataComplete(boolean metadataComplete) {
        this.metadataComplete = metadataComplete;
    }

    @Override
    public void setThumbnail(boolean thumbnail) {
        this.thumbnail = thumbnail;
    }

    @Override
    public void setAxes(CalibratedAxis[] axes, long[] axisLengths) {
        this.setAxes(axes);
        this.setAxisLengths(axisLengths);
    }

    @Override
    public void setAxisTypes(AxisType ... axisTypes) {
        CalibratedAxis[] axes = new CalibratedAxis[axisTypes.length];
        for (int i = 0; i < axisTypes.length; ++i) {
            AxisType t = axisTypes[i];
            CalibratedAxis c = this.getAxis(t);
            if (c == null) {
                c = FormatTools.createAxis(t);
            }
            axes[i] = c;
        }
        this.setAxes(axes);
    }

    @Override
    public void setAxes(CalibratedAxis ... axisTypes) {
        this.axes = new ArrayList<CalibratedAxis>(Arrays.asList(axisTypes));
        this.clearCachedAxes();
    }

    @Override
    public void setAxisLengths(long[] axisLengths) {
        if (axisLengths.length > this.axes.size()) {
            throw new IllegalArgumentException("Tried to set " + axisLengths.length + " axis lengths, but " + this.getAxes().size() + " axes present. Call setAxisTypes first.");
        }
        for (int i = 0; i < axisLengths.length; ++i) {
            this.updateLength(this.axes.get(i).type(), axisLengths[i]);
        }
    }

    @Override
    public void setAxisLength(CalibratedAxis axis, long length) {
        this.setAxisLength(axis.type(), length);
    }

    @Override
    public void setAxisLength(AxisType axisType, long length) {
        if (this.getAxisIndex(axisType, this.axes) == -1) {
            this.addAxis(FormatTools.createAxis(axisType), length);
        } else {
            this.updateLength(axisType, length);
        }
    }

    @Override
    public void setAxis(int index, CalibratedAxis axis) {
        int oldIndex = this.getAxisIndex(axis);
        if (oldIndex < 0) {
            long length = this.axisLengths.remove(this.axes.get(index).type());
            this.axes.remove(index);
            if (index == this.axes.size()) {
                this.axes.add(axis);
            } else {
                this.axes.add(index, axis);
            }
            this.axisLengths.put(axis.type(), length);
        } else {
            this.axes.remove(this.axes.get(oldIndex));
            this.axes.add(index, axis);
        }
        this.clearCachedAxes();
    }

    @Override
    public void setAxisType(int index, AxisType axisType) {
        CalibratedAxis axis = FormatTools.createAxis(axisType);
        this.setAxis(index, axis);
    }

    @Override
    public long getSize() {
        long size = 1L;
        for (CalibratedAxis a : this.getAxes()) {
            size = ArrayUtils.safeMultiply64((long[])new long[]{size, this.getAxisLength(a)});
        }
        int bytesPerPixel = this.getBitsPerPixel() / 8;
        return ArrayUtils.safeMultiply64((long[])new long[]{size, bytesPerPixel});
    }

    @Override
    public long getPlaneSize() {
        return this.getSize() / this.getPlaneCount();
    }

    @Override
    public long getThumbSizeX() {
        long thumbX = this.thumbSizeX;
        if (thumbX == 0L) {
            long sx = this.getAxisLength(Axes.X);
            long sy = this.getAxisLength(Axes.Y);
            if (sx < 128L && sy < 128L) {
                thumbX = sx;
            } else if (sx > sy) {
                thumbX = 128L;
            } else if (sy > 0L) {
                thumbX = sx * 128L / sy;
            }
            if (thumbX == 0L) {
                thumbX = 1L;
            }
        }
        return thumbX;
    }

    @Override
    public long getThumbSizeY() {
        long thumbY = this.thumbSizeY;
        if (thumbY == 0L) {
            long sx = this.getAxisLength(Axes.X);
            long sy = this.getAxisLength(Axes.Y);
            thumbY = 1L;
            if (sx < 128L && sy < 128L) {
                thumbY = sy;
            } else if (sy > sx) {
                thumbY = 128L;
            } else if (sx > 0L) {
                thumbY = sy * 128L / sx;
            }
            if (thumbY == 0L) {
                thumbY = 1L;
            }
        }
        return thumbY;
    }

    @Override
    public CalibratedAxis getAxis(AxisType axisType) {
        for (CalibratedAxis axis : this.getAxes()) {
            if (!axis.type().equals(axisType)) continue;
            return axis;
        }
        return null;
    }

    @Override
    public int getPixelType() {
        return this.pixelType;
    }

    @Override
    public int getBitsPerPixel() {
        if (this.bitsPerPixel <= 0) {
            return FormatTools.getBitsPerPixel(this.pixelType);
        }
        return this.bitsPerPixel;
    }

    @Override
    public List<CalibratedAxis> getAxes() {
        return this.getEffectiveAxes();
    }

    @Override
    public List<CalibratedAxis> getAxesPlanar() {
        return this.getAxisList(true);
    }

    @Override
    public List<CalibratedAxis> getAxesNonPlanar() {
        return this.getAxisList(false);
    }

    @Override
    public long getPlaneCount() {
        long length = 1L;
        for (CalibratedAxis t : this.getAxesNonPlanar()) {
            length *= this.getAxisLength(t);
        }
        return length;
    }

    @Override
    public long[] getAxesLengths() {
        return this.getAxesLengths(this.getAxes());
    }

    @Override
    public long[] getAxesLengths(List<CalibratedAxis> axes) {
        long[] lengths = new long[axes.size()];
        for (int i = 0; i < axes.size(); ++i) {
            lengths[i] = this.getAxisLength(axes.get(i));
        }
        return lengths;
    }

    @Override
    public long[] getAxesLengthsPlanar() {
        return this.getAxesLengths(this.getAxesPlanar());
    }

    @Override
    public long[] getAxesLengthsNonPlanar() {
        return this.getAxesLengths(this.getAxesNonPlanar());
    }

    @Override
    public boolean isOrderCertain() {
        return this.orderCertain;
    }

    @Override
    public boolean isLittleEndian() {
        return this.littleEndian;
    }

    @Override
    public boolean isIndexed() {
        return this.indexed;
    }

    @Override
    public int getPlanarAxisCount() {
        if (this.planarAxisCount == -1) {
            return SCIFIOMetadataTools.guessPlanarAxisCount(this.axes);
        }
        return this.planarAxisCount;
    }

    @Override
    public int getInterleavedAxisCount() {
        if (this.interleavedAxisCount == -1) {
            return SCIFIOMetadataTools.guessInterleavedAxisCount(this.axes);
        }
        return this.interleavedAxisCount;
    }

    @Override
    public boolean isMultichannel() {
        int cIndex = this.getAxisIndex(Axes.CHANNEL);
        return cIndex < this.getPlanarAxisCount() && cIndex >= 0;
    }

    @Override
    public boolean isFalseColor() {
        return this.falseColor;
    }

    @Override
    public boolean isMetadataComplete() {
        return this.metadataComplete;
    }

    @Override
    public boolean isThumbnail() {
        return this.thumbnail;
    }

    @Override
    public CalibratedAxis getAxis(int axisIndex) {
        return this.getAxes().get(axisIndex);
    }

    @Override
    public long getAxisLength(int axisIndex) {
        if (axisIndex < 0 || axisIndex >= this.getAxes().size()) {
            return 1L;
        }
        return this.getAxisLength(this.getAxis(axisIndex));
    }

    @Override
    public long getAxisLength(CalibratedAxis t) {
        return t == null ? 1L : this.getAxisLength(t.type());
    }

    @Override
    public long getAxisLength(AxisType t) {
        if (this.axisLengths == null || !this.axisLengths.containsKey(t) || this.effectiveAxes != null && this.getAxisIndex(t) == -1) {
            return 1L;
        }
        return this.axisLengths.get(t);
    }

    @Override
    public int getAxisIndex(CalibratedAxis axis) {
        return this.getAxisIndex(axis.type());
    }

    @Override
    public int getAxisIndex(AxisType axisType) {
        List<CalibratedAxis> knownAxes = this.effectiveAxes == null ? this.axes : this.effectiveAxes;
        return this.getAxisIndex(axisType, knownAxes);
    }

    @Override
    public void addAxis(CalibratedAxis axis) {
        this.addAxis(axis, 1L);
    }

    @Override
    public void addAxis(CalibratedAxis axis, long value) {
        if (this.axes == null) {
            this.axes = new ArrayList<CalibratedAxis>();
        }
        if (!this.axes.contains(axis)) {
            this.axes.add(axis);
            this.clearCachedAxes();
        }
        this.updateLength(axis.type(), value);
    }

    @Override
    public void addAxis(AxisType axisType, long value) {
        this.addAxis(FormatTools.createAxis(axisType), value);
    }

    @Override
    public void copy(ImageMetadata toCopy) {
        this.populate(toCopy.getName(), toCopy.getAxes(), toCopy.getAxesLengths(), toCopy.getPixelType(), toCopy.isOrderCertain(), toCopy.isLittleEndian(), toCopy.isIndexed(), toCopy.isFalseColor(), toCopy.isMetadataComplete());
        this.table = new DefaultMetaTable(toCopy.getTable());
        this.thumbnail = toCopy.isThumbnail();
        this.thumbSizeX = toCopy.getThumbSizeX();
        this.thumbSizeY = toCopy.getThumbSizeY();
        this.planarAxisCount = toCopy.getPlanarAxisCount();
    }

    @Override
    public void populate(String name, List<CalibratedAxis> axes, long[] lengths, int pixelType, boolean orderCertain, boolean littleEndian, boolean indexed, boolean falseColor, boolean metadataComplete) {
        this.populate(name, axes, lengths, pixelType, FormatTools.getBitsPerPixel(pixelType), orderCertain, littleEndian, indexed, falseColor, metadataComplete);
    }

    @Override
    public void populate(String name, List<CalibratedAxis> axes, long[] lengths, int pixelType, int bitsPerPixel, boolean orderCertain, boolean littleEndian, boolean indexed, boolean falseColor, boolean metadataComplete) {
        this.name = name;
        this.axes = new ArrayList<CalibratedAxis>(axes);
        this.setAxisLengths((long[])lengths.clone());
        this.bitsPerPixel = bitsPerPixel;
        this.falseColor = falseColor;
        this.indexed = indexed;
        this.littleEndian = littleEndian;
        this.orderCertain = orderCertain;
        this.pixelType = pixelType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public MetaTable getTable() {
        if (this.table == null) {
            this.table = new DefaultMetaTable();
        }
        return this.table;
    }

    @Override
    public void setTable(MetaTable table) {
        this.table = table;
    }

    public String toString() {
        return new FieldPrinter(this).toString();
    }

    private List<CalibratedAxis> getEffectiveAxes() {
        if (this.effectiveAxes == null && this.axes != null) {
            CalibratedAxis axis;
            int end;
            for (end = this.axes.size(); end > this.getPlanarAxisCount() && this.getAxisLength(axis = this.axes.get(end - 1)) <= 1L; --end) {
            }
            this.effectiveAxes = new ArrayList<CalibratedAxis>();
            for (int i = 0; i < end; ++i) {
                this.effectiveAxes.add(this.axes.get(i));
            }
        }
        return this.effectiveAxes;
    }

    private int getAxisIndex(AxisType axisType, List<CalibratedAxis> axisList) {
        if (axisList == null) {
            return -1;
        }
        int index = -1;
        for (int i = 0; index == -1 && i < axisList.size(); ++i) {
            if (!axisList.get(i).type().equals(axisType)) continue;
            index = i;
        }
        return index;
    }

    private void clearCachedAxes() {
        this.planarAxes = null;
        this.extendedAxes = null;
        this.effectiveAxes = null;
    }

    private void updateLength(AxisType axisType, long value) {
        this.axisLengths.put(axisType, value);
        this.effectiveAxes = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CalibratedAxis> getAxisList(boolean planar) {
        int index = -1;
        int end = -1;
        List<CalibratedAxis> axisList = null;
        if (planar) {
            if (this.planarAxes == null) {
                this.planarAxes = new ArrayList<CalibratedAxis>();
            }
            axisList = this.planarAxes;
            index = 0;
            end = this.getPlanarAxisCount();
        } else {
            if (this.extendedAxes == null) {
                this.extendedAxes = new ArrayList<CalibratedAxis>();
            }
            axisList = this.extendedAxes;
            index = this.getPlanarAxisCount();
            end = this.getAxes().size();
        }
        if (axisList.size() == 0) {
            List<CalibratedAxis> list = axisList;
            synchronized (list) {
                if (axisList.size() == 0) {
                    axisList.clear();
                    int position = 0;
                    while (index < end) {
                        if (position <= axisList.size()) {
                            axisList.add(this.getAxes().get(index));
                            ++position;
                        } else {
                            axisList.set(position++, this.getAxes().get(index));
                        }
                        ++index;
                    }
                }
            }
        }
        return axisList;
    }
}

