/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.types;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import net.imglib2.type.numeric.RealType;

public class PreciseFixedFloatType
implements RealType<PreciseFixedFloatType> {
    private static final int DECIMAL_PLACES = 25;
    private BigInteger scale;
    private BigInteger amount;
    private static final PreciseFixedFloatType ZERO = new PreciseFixedFloatType();
    private static final PreciseFixedFloatType ONE = new PreciseFixedFloatType(1L);
    private static final PreciseFixedFloatType TWO = new PreciseFixedFloatType(2L);
    private static final PreciseFixedFloatType PI = new PreciseFixedFloatType("3.14159265358979323846264338327950288419716939937510");
    private static PreciseFixedFloatType[] ANGLES = PreciseFixedFloatType.angles();
    private static PreciseFixedFloatType[] POWERS_OF_TWO = PreciseFixedFloatType.powersOfTwo();
    private static PreciseFixedFloatType SQRT_PRE = PreciseFixedFloatType.sqrtPrecision();

    public PreciseFixedFloatType() {
        this.scale = BigInteger.TEN.pow(25);
        this.amount = BigInteger.ZERO;
    }

    public PreciseFixedFloatType(long v) {
        this();
        this.set(v);
    }

    public PreciseFixedFloatType(double v) {
        this();
        this.set(v);
    }

    public PreciseFixedFloatType(BigInteger v) {
        this();
        this.set(v);
    }

    public PreciseFixedFloatType(BigDecimal v) {
        this();
        this.set(v);
    }

    public PreciseFixedFloatType(String numStr) {
        this();
        this.set(new BigDecimal(numStr));
    }

    public PreciseFixedFloatType(PreciseFixedFloatType other) {
        this.scale = other.scale;
        this.amount = other.amount;
    }

    public BigDecimal get() {
        BigDecimal numer = new BigDecimal(this.amount);
        BigDecimal denom = new BigDecimal(this.scale);
        return numer.divide(denom);
    }

    @Override
    public double getRealDouble() {
        return this.get().doubleValue();
    }

    @Override
    public float getRealFloat() {
        return this.get().floatValue();
    }

    @Override
    public double getImaginaryDouble() {
        return 0.0;
    }

    @Override
    public float getImaginaryFloat() {
        return 0.0f;
    }

    @Override
    public void setReal(float v) {
        this.set(v);
    }

    @Override
    public void setReal(double v) {
        this.set(v);
    }

    @Override
    public void setImaginary(float v) {
    }

    @Override
    public void setImaginary(double v) {
    }

    @Override
    public void setComplexNumber(float r, float i) {
        this.set(r);
    }

    @Override
    public void setComplexNumber(double r, double i) {
        this.set(r);
    }

    @Override
    public float getPowerFloat() {
        return this.getRealFloat();
    }

    @Override
    public double getPowerDouble() {
        return this.getRealDouble();
    }

    @Override
    public float getPhaseFloat() {
        return 0.0f;
    }

    @Override
    public double getPhaseDouble() {
        return 0.0;
    }

    @Override
    public void complexConjugate() {
    }

    public void negate() {
        this.amount = this.amount.negate();
    }

    public void abs() {
        if (this.amount.compareTo(BigInteger.ZERO) < 0) {
            this.negate();
        }
    }

    public void pow(int power) {
        if (power < 0) {
            PreciseFixedFloatType factor = new PreciseFixedFloatType(this);
            for (int i = 0; i < -power + 1; ++i) {
                this.div(this, factor);
            }
        } else if (power == 0) {
            this.amount = this.scale;
        } else {
            PreciseFixedFloatType factor = new PreciseFixedFloatType(this);
            for (int p = 1; p < power; ++p) {
                this.mul(this, factor);
            }
        }
    }

    @Override
    public void add(PreciseFixedFloatType v) {
        this.add(this, v);
    }

    public void add(PreciseFixedFloatType a, PreciseFixedFloatType b) {
        this.amount = a.amount.add(b.amount);
    }

    @Override
    public void sub(PreciseFixedFloatType v) {
        this.sub(this, v);
    }

    public void sub(PreciseFixedFloatType a, PreciseFixedFloatType b) {
        this.amount = a.amount.subtract(b.amount);
    }

    @Override
    public void mul(PreciseFixedFloatType v) {
        this.mul(this, v);
    }

    public void mul(PreciseFixedFloatType a, PreciseFixedFloatType b) {
        this.amount = a.amount.multiply(b.amount).divide(this.scale);
    }

    @Override
    public void div(PreciseFixedFloatType v) {
        this.div(this, v);
    }

    public void div(PreciseFixedFloatType a, PreciseFixedFloatType b) {
        this.amount = a.amount.multiply(this.scale).divide(b.amount);
    }

    @Override
    public void setZero() {
        this.amount = BigInteger.ZERO;
    }

    @Override
    public void setOne() {
        this.amount = this.scale;
    }

    @Override
    public void mul(float v) {
        this.mul(BigDecimal.valueOf(v));
    }

    @Override
    public void mul(double v) {
        this.mul(BigDecimal.valueOf(v));
    }

    @Override
    public void mul(BigInteger v) {
        this.amount = this.amount.multiply(v);
    }

    @Override
    public void mul(BigDecimal v) {
        BigDecimal integer = new BigDecimal(this.amount);
        BigDecimal number = integer.multiply(v);
        this.amount = number.toBigInteger();
    }

    @Override
    public PreciseFixedFloatType createVariable() {
        return new PreciseFixedFloatType();
    }

    @Override
    public PreciseFixedFloatType copy() {
        return new PreciseFixedFloatType(this);
    }

    @Override
    public void set(PreciseFixedFloatType other) {
        this.scale = other.scale;
        this.amount = other.amount;
    }

    @Override
    public void set(double v) {
        this.set(BigDecimal.valueOf(v));
    }

    @Override
    public void set(long v) {
        this.set(BigInteger.valueOf(v));
    }

    @Override
    public void set(BigInteger v) {
        this.amount = v.multiply(this.scale);
    }

    @Override
    public void set(BigDecimal v) {
        BigDecimal scaled = v.multiply(new BigDecimal(this.scale));
        this.amount = scaled.toBigInteger();
    }

    @Override
    public int compareTo(PreciseFixedFloatType other) {
        return this.amount.compareTo(other.amount);
    }

    @Override
    public void inc() {
        this.amount = this.amount.add(this.scale);
    }

    @Override
    public void dec() {
        this.amount = this.amount.subtract(this.scale);
    }

    @Override
    public double getMaxValue() {
        return Double.MAX_VALUE;
    }

    @Override
    public double getMinValue() {
        return -1.7976931348623157E308;
    }

    @Override
    public double getMinIncrement() {
        return 1.0 / Math.pow(10.0, 25.0);
    }

    @Override
    public int getBitsPerPixel() {
        return 1024;
    }

    @Override
    public boolean valueEquals(PreciseFixedFloatType t) {
        return Objects.equals(this.get(), t.get());
    }

    public String toString() {
        return this.get().toString();
    }

    public static PreciseFixedFloatType sqrt(PreciseFixedFloatType c) {
        PreciseFixedFloatType precision = new PreciseFixedFloatType();
        precision.div(ONE, SQRT_PRE);
        return PreciseFixedFloatType.sqrtNewtonRaphson(c, ONE, precision);
    }

    private static PreciseFixedFloatType sqrtNewtonRaphson(PreciseFixedFloatType c, PreciseFixedFloatType xn, PreciseFixedFloatType precision) {
        PreciseFixedFloatType negC = new PreciseFixedFloatType(c);
        negC.negate();
        PreciseFixedFloatType fx = new PreciseFixedFloatType(xn);
        fx.pow(2);
        fx.add(negC);
        PreciseFixedFloatType fpx = new PreciseFixedFloatType();
        fpx.mul(xn, TWO);
        PreciseFixedFloatType xn1 = new PreciseFixedFloatType();
        xn1.div(fx, fpx);
        PreciseFixedFloatType negXn1 = new PreciseFixedFloatType(xn1);
        negXn1.negate();
        xn1.add(xn, negXn1);
        PreciseFixedFloatType currentSquare = new PreciseFixedFloatType(xn1);
        currentSquare.pow(2);
        PreciseFixedFloatType currentPrecision = new PreciseFixedFloatType();
        currentPrecision.sub(currentSquare, c);
        currentPrecision.abs();
        if (xn.compareTo(xn1) == 0) {
            return xn;
        }
        if (currentPrecision.compareTo(precision) > 0) {
            return PreciseFixedFloatType.sqrtNewtonRaphson(c, xn1, precision);
        }
        return xn1;
    }

    public static PreciseFixedFloatType atan2(PreciseFixedFloatType y, PreciseFixedFloatType x) {
        PreciseFixedFloatType tx = x.copy();
        PreciseFixedFloatType ty = y.copy();
        PreciseFixedFloatType angle = new PreciseFixedFloatType(0L);
        if (tx.compareTo(ZERO) < 0) {
            angle.set(PI);
            tx.negate();
            ty.negate();
        } else if (ty.compareTo(ZERO) < 0) {
            angle.mul(TWO, PI);
        }
        PreciseFixedFloatType xNew = new PreciseFixedFloatType();
        PreciseFixedFloatType yNew = new PreciseFixedFloatType();
        PreciseFixedFloatType dx = new PreciseFixedFloatType();
        PreciseFixedFloatType dy = new PreciseFixedFloatType();
        for (int j = 0; j < ANGLES.length; ++j) {
            PreciseFixedFloatType twoPowJ = POWERS_OF_TWO[j];
            dy.div(ty, twoPowJ);
            dx.div(tx, twoPowJ);
            if (ty.compareTo(ZERO) < 0) {
                xNew.sub(tx, dy);
                yNew.add(ty, dx);
                angle.sub(ANGLES[j]);
            } else {
                xNew.add(tx, dy);
                yNew.sub(ty, dx);
                angle.add(ANGLES[j]);
            }
            tx.set(xNew);
            ty.set(yNew);
        }
        return angle;
    }

    private static PreciseFixedFloatType[] angles() {
        return new PreciseFixedFloatType[]{new PreciseFixedFloatType("0.7853981633974483096156608458198757210492923498437764"), new PreciseFixedFloatType("0.4636476090008061162142562314612144020285370542861202"), new PreciseFixedFloatType("0.2449786631268641541720824812112758109141440983811840"), new PreciseFixedFloatType("0.1243549945467614350313548491638710255731701917698040"), new PreciseFixedFloatType("0.0624188099959573484739791129855051136062738877974991"), new PreciseFixedFloatType("0.0312398334302682762537117448924909770324956637254000"), new PreciseFixedFloatType("0.0156237286204768308028015212565703189111141398009054"), new PreciseFixedFloatType("0.0078123410601011112964633918421992816212228117250147"), new PreciseFixedFloatType("0.0039062301319669718276286653114243871403574901152028"), new PreciseFixedFloatType("0.0019531225164788186851214826250767139316107467772335"), new PreciseFixedFloatType("0.0009765621895593194304034301997172908516341970158100"), new PreciseFixedFloatType("0.0004882812111948982754692396256448486661923611331350"), new PreciseFixedFloatType("0.0002441406201493617640167229432596599862124177909706"), new PreciseFixedFloatType("0.0001220703118936702042390586461179563009308294090157"), new PreciseFixedFloatType("0.0000610351561742087750216625691738291537851435368333"), new PreciseFixedFloatType("0.0000305175781155260968618259534385360197509496751194"), new PreciseFixedFloatType("0.0000152587890613157621072319358126978851374292381445"), new PreciseFixedFloatType("0.0000076293945311019702633884823401050905863507439184"), new PreciseFixedFloatType("0.0000038146972656064962829230756163729937228052573039"), new PreciseFixedFloatType("0.0000019073486328101870353653693059172441687143421654"), new PreciseFixedFloatType("0.00000095367431640596087942067068992311239001963412449"), new PreciseFixedFloatType("0.00000047683715820308885992758382144924707587049404378"), new PreciseFixedFloatType("0.00000023841857910155798249094797721893269783096898769"), new PreciseFixedFloatType("0.00000011920928955078068531136849713792211264596758766"), new PreciseFixedFloatType("0.000000059604644775390554413921062141788874250030195782"), new PreciseFixedFloatType("0.000000029802322387695303676740132767709503349043907067"), new PreciseFixedFloatType("0.000000014901161193847655147092516595963247108248930025"), new PreciseFixedFloatType("0.0000000074505805969238279871365645744953921132066925545"), new PreciseFixedFloatType("0.0000000037252902984619140452670705718119235836719483287"), new PreciseFixedFloatType("0.0000000018626451492309570290958838214764904345065282835"), new PreciseFixedFloatType("0.0000000009313225746154785153557354776845613038929264961"), new PreciseFixedFloatType("0.0000000004656612873077392577788419347105701629734786389"), new PreciseFixedFloatType("0.0000000002328306436538696289020427418388212703712742932"), new PreciseFixedFloatType("0.0000000001164153218269348144525990927298526587963964573"), new PreciseFixedFloatType("0.00000000005820766091346740722649676159123158234954915625"), new PreciseFixedFloatType("0.00000000002910383045673370361327303269890394779369363200"), new PreciseFixedFloatType("0.00000000001455191522836685180663959783736299347421170360"), new PreciseFixedFloatType("0.000000000007275957614183425903320184104670374184276462938"), new PreciseFixedFloatType("0.000000000003637978807091712951660140200583796773034557866"), new PreciseFixedFloatType("0.000000000001818989403545856475830076118822974596629319733"), new PreciseFixedFloatType("0.0000000000009094947017729282379150388117278718245786649666"), new PreciseFixedFloatType("0.0000000000004547473508864641189575194999034839780723331208"), new PreciseFixedFloatType("0.0000000000002273736754432320594787597617066854972590416401"), new PreciseFixedFloatType("0.0000000000001136868377216160297393798823227106871573802050"), new PreciseFixedFloatType("0.00000000000005684341886080801486968994134502633589467252562")};
    }

    private static PreciseFixedFloatType[] powersOfTwo() {
        PreciseFixedFloatType[] powers = new PreciseFixedFloatType[ANGLES.length];
        PreciseFixedFloatType term = new PreciseFixedFloatType(1L);
        for (int i = 0; i < ANGLES.length; ++i) {
            powers[i] = term.copy();
            term.mul(TWO);
        }
        return powers;
    }

    private static PreciseFixedFloatType sqrtPrecision() {
        PreciseFixedFloatType prec = new PreciseFixedFloatType(10L);
        prec.pow(24);
        return prec;
    }
}

