/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.types;

import net.imagej.types.BigComplex;
import net.imagej.types.DataType;
import net.imglib2.type.numeric.complex.ComplexFloatType;
import org.scijava.AbstractContextual;

public class DataType64BitSignedComplexFloat
extends AbstractContextual
implements DataType<ComplexFloatType> {
    private ComplexFloatType type = new ComplexFloatType();

    @Override
    public ComplexFloatType getType() {
        return this.type;
    }

    @Override
    public String shortName() {
        return "64-bit complex";
    }

    @Override
    public String longName() {
        return "64-bit complex float";
    }

    @Override
    public String description() {
        return "A complex floating data type with 32-bit float subcomponents";
    }

    @Override
    public boolean isComplex() {
        return true;
    }

    @Override
    public boolean isFloat() {
        return true;
    }

    @Override
    public boolean isSigned() {
        return true;
    }

    @Override
    public boolean isBounded() {
        return false;
    }

    @Override
    public void lowerBound(ComplexFloatType dest) {
        throw new UnsupportedOperationException("complex numbers are unbounded");
    }

    @Override
    public void upperBound(ComplexFloatType dest) {
        throw new UnsupportedOperationException("complex numbers are unbounded");
    }

    @Override
    public int bitCount() {
        return 64;
    }

    @Override
    public ComplexFloatType createVariable() {
        return new ComplexFloatType();
    }

    @Override
    public void cast(ComplexFloatType val, BigComplex dest) {
        dest.setReal(val.getRealFloat());
        dest.setImag(val.getImaginaryFloat());
    }

    @Override
    public void cast(BigComplex val, ComplexFloatType dest) {
        dest.setReal(val.getReal().floatValue());
        dest.setImaginary(val.getImag().floatValue());
    }

    @Override
    public boolean hasDoubleRepresentation() {
        return false;
    }

    @Override
    public boolean hasLongRepresentation() {
        return false;
    }

    @Override
    public double asDouble(ComplexFloatType val) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long asLong(ComplexFloatType val) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDouble(ComplexFloatType val, double v) {
        val.setReal(v);
        val.setImaginary(0.0f);
    }

    @Override
    public void setLong(ComplexFloatType val, long v) {
        val.setReal(v);
        val.setImaginary(0.0f);
    }
}

