/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.overlay;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import net.imagej.axis.Axes;
import net.imagej.axis.DefaultLinearAxis;
import net.imagej.overlay.AbstractROIOverlay;
import net.imagej.overlay.Overlay;
import net.imglib2.AbstractCursorInt;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RealCursor;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.img.basictypeaccess.array.LongArray;
import net.imglib2.roi.BinaryMaskRegionOfInterest;
import net.imglib2.type.logic.BitType;
import net.imglib2.view.Views;
import org.scijava.Context;

public class BinaryMaskOverlay<U extends BitType, V extends Img<U>>
extends AbstractROIOverlay<BinaryMaskRegionOfInterest<U, V>> {
    private static final long serialVersionUID = 1L;

    public BinaryMaskOverlay() {
        super((Context)null, null);
    }

    public BinaryMaskOverlay(Context context) {
        super(context, null);
    }

    public BinaryMaskOverlay(Context context, BinaryMaskRegionOfInterest<U, V> roi) {
        super(context, roi);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        BinaryMaskRegionOfInterest theRoi = (BinaryMaskRegionOfInterest)this.getRegionOfInterest();
        RandomAccessible<BitType> ra = this.constantImg(theRoi.numDimensions());
        IterableInterval<BitType> ii = theRoi.getIterableIntervalOverROI(ra);
        RealCursor c = ii.localizingCursor();
        out.writeInt(theRoi.numDimensions());
        for (int i = 0; i < theRoi.numDimensions(); ++i) {
            out.writeLong(ii.dimension(i));
        }
        double[] maskOrigin = theRoi.getOrigin();
        for (int i = 0; i < maskOrigin.length; ++i) {
            out.writeDouble(maskOrigin[i]);
        }
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        DataOutputStream ds = new DataOutputStream(new DeflaterOutputStream(s));
        long[] initial_position = new long[theRoi.numDimensions()];
        long[] next_position = new long[theRoi.numDimensions()];
        Arrays.fill(initial_position, Long.MIN_VALUE);
        long run = 0L;
        while (c.hasNext()) {
            c.next();
            next_position[0] = initial_position[0] + run;
            for (int i = 0; i < theRoi.numDimensions(); ++i) {
                if (next_position[i] == c.getLongPosition(i)) continue;
                if (run > 0L) {
                    ds.writeLong(run);
                    for (int j = 0; j < theRoi.numDimensions(); ++j) {
                        ds.writeLong(initial_position[j]);
                    }
                }
                run = 0L;
                c.localize(initial_position);
                c.localize(next_position);
                break;
            }
            ++run;
        }
        if (run > 0L) {
            ds.writeLong(run);
            for (int j = 0; j < theRoi.numDimensions(); ++j) {
                ds.writeLong(initial_position[j]);
            }
        }
        ds.writeLong(0L);
        ds.close();
        byte[] buffer = s.toByteArray();
        out.writeInt(buffer.length);
        out.write(buffer);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        long run;
        super.readExternal(in);
        int nDimensions = in.readInt();
        long[] dimensions = new long[nDimensions];
        for (int i = 0; i < nDimensions; ++i) {
            dimensions[i] = in.readLong();
        }
        double[] maskOrigin = new double[nDimensions];
        for (int i = 0; i < nDimensions; ++i) {
            maskOrigin[i] = in.readDouble();
        }
        ArrayImg<BitType, LongArray> img = ArrayImgs.bits(dimensions);
        img.setLinkedType(new BitType(img));
        RandomAccess ra = img.randomAccess();
        byte[] buffer = new byte[in.readInt()];
        in.read(buffer);
        ByteArrayInputStream s = new ByteArrayInputStream(buffer);
        DataInputStream ds = new DataInputStream(new InflaterInputStream(s));
        long[] position = new long[nDimensions];
        while ((run = ds.readLong()) != 0L) {
            int i;
            for (i = 0; i < nDimensions; ++i) {
                position[i] = ds.readLong();
            }
            i = 0;
            while ((long)i < run) {
                ra.setPosition(position);
                position[0] = position[0] + 1L;
                ((BitType)ra.get()).set(true);
                ++i;
            }
        }
        this.setRegionOfInterest(new BinaryMaskRegionOfInterest(img));
        ((BinaryMaskRegionOfInterest)this.getRegionOfInterest()).move(maskOrigin);
    }

    @Override
    public Overlay duplicate() {
        BinaryMaskRegionOfInterest newRoi = new BinaryMaskRegionOfInterest(((Img)((BinaryMaskRegionOfInterest)this.getRegionOfInterest()).getImg()).copy());
        newRoi.move(((BinaryMaskRegionOfInterest)this.getRegionOfInterest()).getOrigin());
        BinaryMaskOverlay overlay = new BinaryMaskOverlay(this.getContext(), newRoi);
        overlay.setAlpha(this.getAlpha());
        overlay.setAxis(new DefaultLinearAxis(Axes.X), 0);
        overlay.setAxis(new DefaultLinearAxis(Axes.Y), 1);
        overlay.setFillColor(this.getFillColor());
        overlay.setLineColor(this.getLineColor());
        overlay.setLineEndArrowStyle(this.getLineEndArrowStyle());
        overlay.setLineStartArrowStyle(this.getLineStartArrowStyle());
        overlay.setLineStyle(this.getLineStyle());
        overlay.setLineWidth(this.getLineWidth());
        overlay.setName(this.getName());
        return overlay;
    }

    @Override
    public void move(double[] deltas) {
        ((BinaryMaskRegionOfInterest)this.getRegionOfInterest()).move(deltas);
    }

    private RandomAccessible<BitType> constantImg(int numDims) {
        long[] dims = new long[numDims];
        Arrays.fill(dims, 1L);
        ArrayImg<BitType, LongArray> bitImg = ArrayImgs.bits(dims);
        bitImg.setLinkedType(new BitType(bitImg));
        ((BitType)((AbstractCursorInt)bitImg.cursor()).next()).set(true);
        return Views.extendBorder(bitImg);
    }
}

