/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.display;

import net.imglib2.display.ColorTable;
import net.imglib2.display.ColorTable8;
import org.scijava.util.ColorRGB;

public final class ColorTables {
    public static final ColorTable8 FIRE = ColorTables.fire();
    public static final ColorTable8 ICE = ColorTables.ice();
    public static final ColorTable8 SPECTRUM = ColorTables.spectrum();
    public static final ColorTable8 RGB332 = ColorTables.rgb332();
    public static final ColorTable8 RED = ColorTables.primary(4);
    public static final ColorTable8 GREEN = ColorTables.primary(2);
    public static final ColorTable8 BLUE = ColorTables.primary(1);
    public static final ColorTable8 CYAN = ColorTables.primary(3);
    public static final ColorTable8 MAGENTA = ColorTables.primary(5);
    public static final ColorTable8 YELLOW = ColorTables.primary(6);
    public static final ColorTable8 GRAYS = ColorTables.primary(7);
    public static final ColorTable8 REDGREEN = ColorTables.redGreen();

    private ColorTables() {
    }

    public static ColorTable8 getDefaultColorTable(int c) {
        switch (c) {
            case 0: {
                return RED;
            }
            case 1: {
                return GREEN;
            }
            case 2: {
                return BLUE;
            }
            case 3: {
                return CYAN;
            }
            case 4: {
                return MAGENTA;
            }
            case 5: {
                return YELLOW;
            }
        }
        return GRAYS;
    }

    public static boolean isGrayColorTable(ColorTable table) {
        if (table == GRAYS) {
            return true;
        }
        int numChannels = table.getComponentCount();
        int tableLen = table.getLength();
        for (int i = 0; i < tableLen; ++i) {
            int value = table.get(0, i);
            for (int c = 1; c < numChannels; ++c) {
                if (table.get(c, i) == value) continue;
                return false;
            }
        }
        return true;
    }

    private static ColorTable8 fire() {
        int[][] v = new int[][]{{0, 0, 1, 25, 49, 73, 98, 122, 146, 162, 173, 184, 195, 207, 217, 229, 240, 252, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14, 35, 57, 79, 101, 117, 133, 147, 161, 175, 190, 205, 219, 234, 248, 255, 255, 255, 255}, {0, 61, 96, 130, 165, 192, 220, 227, 210, 181, 151, 122, 93, 64, 35, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 35, 98, 160, 223, 255}};
        return ColorTables.custom(v);
    }

    private static ColorTable8 ice() {
        int[][] v = new int[][]{{0, 0, 0, 0, 0, 0, 19, 29, 50, 48, 79, 112, 134, 158, 186, 201, 217, 229, 242, 250, 250, 250, 250, 251, 250, 250, 250, 250, 251, 251, 243, 230}, {156, 165, 176, 184, 190, 196, 193, 184, 171, 162, 146, 125, 107, 93, 81, 87, 92, 97, 95, 93, 93, 90, 85, 69, 64, 54, 47, 35, 19, 0, 4, 0}, {140, 147, 158, 166, 170, 176, 209, 220, 234, 225, 236, 246, 250, 251, 250, 250, 245, 230, 230, 222, 202, 180, 163, 142, 123, 114, 106, 94, 84, 64, 26, 27}};
        return ColorTables.custom(v);
    }

    private static ColorTable8 spectrum() {
        byte[] r = new byte[256];
        byte[] g = new byte[256];
        byte[] b = new byte[256];
        for (int i = 0; i < 256; ++i) {
            ColorRGB c = ColorRGB.fromHSVColor((double)((double)i / 255.0), (double)1.0, (double)1.0);
            r[i] = (byte)c.getRed();
            g[i] = (byte)c.getGreen();
            b[i] = (byte)c.getBlue();
        }
        return new ColorTable8(r, g, b);
    }

    private static ColorTable8 rgb332() {
        byte[] r = new byte[256];
        byte[] g = new byte[256];
        byte[] b = new byte[256];
        for (int i = 0; i < 256; ++i) {
            r[i] = (byte)(i & 0xE0);
            g[i] = (byte)(i << 3 & 0xE0);
            b[i] = (byte)(i << 6 & 0xC0);
        }
        return new ColorTable8(r, g, b);
    }

    private static ColorTable8 redGreen() {
        int i;
        byte[][] values = new byte[3][256];
        for (i = 0; i < 128; ++i) {
            values[0][i] = (byte)(i * 2);
            values[1][i] = 0;
            values[2][i] = 0;
        }
        for (i = 128; i < 256; ++i) {
            values[0][i] = 0;
            values[1][i] = (byte)(i * 2);
            values[2][i] = 0;
        }
        return new ColorTable8(values);
    }

    private static ColorTable8 primary(int color) {
        byte[] r = new byte[256];
        byte[] g = new byte[256];
        byte[] b = new byte[256];
        for (int i = 0; i < 256; ++i) {
            if ((color & 4) != 0) {
                r[i] = (byte)i;
            }
            if ((color & 2) != 0) {
                g[i] = (byte)i;
            }
            if ((color & 1) == 0) continue;
            b[i] = (byte)i;
        }
        return new ColorTable8(r, g, b);
    }

    private static ColorTable8 custom(int[][] v) {
        byte[][] values = new byte[v.length][];
        for (int j = 0; j < v.length; ++j) {
            values[j] = new byte[v[j].length];
            for (int i = 0; i < v[j].length; ++i) {
                values[j][i] = (byte)v[j][i];
            }
        }
        ColorTable8 lut = new ColorTable8(values);
        return ColorTables.interpolate(lut, 256);
    }

    private static ColorTable8 interpolate(ColorTable8 inTable, int outLength) {
        byte[][] inValues = (byte[][])inTable.getValues();
        int componentCount = inValues.length;
        int inLength = inValues[0].length;
        byte[][] outValues = new byte[componentCount][outLength];
        for (int i = 0; i < outLength; ++i) {
            double q = (double)inLength * (double)i / (double)outLength;
            int i1 = (int)q;
            double fraction = q - (double)i1;
            int i2 = i1 + 1;
            if (i2 == inLength) {
                i2 = inLength - 1;
            }
            for (int j = 0; j < componentCount; ++j) {
                outValues[j][i] = (byte)((1.0 - fraction) * (double)(inValues[j][i1] & 0xFF) + fraction * (double)(inValues[j][i2] & 0xFF));
            }
        }
        return new ColorTable8(outValues);
    }
}

