/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.display;

import java.util.HashMap;
import java.util.Map;
import net.imagej.Data;
import net.imagej.Extents;
import net.imagej.Position;
import net.imagej.axis.AxisType;
import net.imagej.axis.CalibratedAxis;
import net.imagej.display.DataView;
import net.imagej.display.event.DataViewDeselectedEvent;
import net.imagej.display.event.DataViewSelectedEvent;
import net.imagej.display.event.DataViewSelectionEvent;
import net.imglib2.Localizable;
import org.scijava.AbstractContextual;
import org.scijava.event.EventService;
import org.scijava.event.SciJavaEvent;
import org.scijava.plugin.Parameter;

public abstract class AbstractDataView
extends AbstractContextual
implements DataView {
    @Parameter(required=false)
    private EventService eventService;
    private Map<AxisType, Long> pos;
    private Data data;
    private boolean disposed;
    private boolean selected;

    @Override
    public void initialize(Data d) {
        if (this.data != null) {
            throw new IllegalStateException("Data already set");
        }
        if (!this.isCompatible(d)) {
            throw new IllegalArgumentException("Incompatible data object: " + d);
        }
        if (this.getContext() != d.getContext()) {
            throw new IllegalArgumentException("Mismatched context: " + d);
        }
        this.data = d;
        this.data.incrementReferences();
        this.pos = new HashMap<AxisType, Long>();
    }

    @Override
    public Data getData() {
        return this.data;
    }

    @Override
    public Position getPlanePosition() {
        long[] planeDims = new long[this.data.numDimensions() - 2];
        for (int d = 0; d < planeDims.length; ++d) {
            planeDims[d] = (long)Math.floor(this.data.realMax(d + 2) - this.data.realMin(d + 2) + 1.0);
        }
        Extents planeExtents = new Extents(planeDims);
        Position planePos = planeExtents.createPosition();
        for (int d = 0; d < planeDims.length; ++d) {
            long dimension;
            int offset = d + 2;
            AxisType axis = ((CalibratedAxis)this.data.axis(offset)).type();
            long p = this.getLongPosition(axis);
            if (p >= (dimension = (long)Math.floor(this.data.realMax(offset) - this.data.realMin(offset) + 1.0))) {
                p = dimension - 1L;
            }
            if (p >= planePos.dimension(d)) {
                p = planePos.dimension(d) - 1L;
            }
            planePos.setPosition(p, d);
        }
        return planePos;
    }

    @Override
    public void setSelected(boolean isSelected) {
        if (this.selected != isSelected) {
            this.selected = isSelected;
            DataViewSelectionEvent event = isSelected ? new DataViewSelectedEvent(this) : new DataViewDeselectedEvent(this);
            this.publish(event);
        }
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        this.data.decrementReferences();
    }

    @Override
    public int getIntPosition(AxisType axis) {
        return (int)this.getLongPosition(axis);
    }

    @Override
    public long getLongPosition(AxisType axis) {
        Long value = this.pos.get(axis);
        return value == null ? 0L : value;
    }

    @Override
    public void setPosition(long position, AxisType axis) {
        this.pos.put(axis, position);
    }

    @Override
    public void localize(int[] position) {
        for (int i = 0; i < position.length; ++i) {
            position[i] = this.getIntPosition(i);
        }
    }

    @Override
    public void localize(long[] position) {
        for (int i = 0; i < position.length; ++i) {
            position[i] = this.getLongPosition(i);
        }
    }

    @Override
    public int getIntPosition(int d) {
        return this.getIntPosition(((CalibratedAxis)this.getData().axis(d)).type());
    }

    @Override
    public long getLongPosition(int d) {
        return this.getLongPosition(((CalibratedAxis)this.getData().axis(d)).type());
    }

    @Override
    public void localize(float[] position) {
        for (int i = 0; i < position.length; ++i) {
            position[i] = this.getFloatPosition(i);
        }
    }

    @Override
    public void localize(double[] position) {
        for (int i = 0; i < position.length; ++i) {
            position[i] = this.getDoublePosition(i);
        }
    }

    @Override
    public float getFloatPosition(int d) {
        return this.getLongPosition(d);
    }

    @Override
    public double getDoublePosition(int d) {
        return this.getLongPosition(d);
    }

    @Override
    public int numDimensions() {
        return this.data.numDimensions();
    }

    @Override
    public void fwd(int d) {
        this.setPosition(this.getLongPosition(d) + 1L, d);
    }

    @Override
    public void bck(int d) {
        this.setPosition(this.getLongPosition(d) - 1L, d);
    }

    @Override
    public void move(int distance, int d) {
        this.setPosition(this.getLongPosition(d) + (long)distance, d);
    }

    @Override
    public void move(long distance, int d) {
        this.setPosition(this.getLongPosition(d) + distance, d);
    }

    @Override
    public void move(Localizable localizable) {
        for (int i = 0; i < localizable.numDimensions(); ++i) {
            this.move(localizable.getLongPosition(i), i);
        }
    }

    @Override
    public void move(int[] distance) {
        for (int i = 0; i < distance.length; ++i) {
            this.move(distance[i], i);
        }
    }

    @Override
    public void move(long[] distance) {
        for (int i = 0; i < distance.length; ++i) {
            this.move(distance[i], i);
        }
    }

    @Override
    public void setPosition(Localizable localizable) {
        for (int i = 0; i < localizable.numDimensions(); ++i) {
            this.setPosition(localizable.getLongPosition(i), i);
        }
    }

    @Override
    public void setPosition(int[] position) {
        for (int i = 0; i < position.length; ++i) {
            this.setPosition(position[i], i);
        }
    }

    @Override
    public void setPosition(long[] position) {
        for (int i = 0; i < position.length; ++i) {
            this.setPosition(position[i], i);
        }
    }

    @Override
    public void setPosition(int position, int d) {
        this.setPosition((long)position, ((CalibratedAxis)this.getData().axis(d)).type());
    }

    @Override
    public void setPosition(long position, int d) {
        this.setPosition(position, ((CalibratedAxis)this.getData().axis(d)).type());
    }

    protected void publish(SciJavaEvent event) {
        if (this.eventService == null) {
            return;
        }
        this.eventService.publish(event);
    }
}

