/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.autoscale;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.imagej.autoscale.AutoscaleMethod;
import net.imagej.autoscale.AutoscaleService;
import net.imagej.autoscale.DataRange;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;
import org.scijava.plugin.AbstractSingletonService;
import org.scijava.plugin.Plugin;
import org.scijava.service.Service;

@Plugin(type=Service.class)
public class DefaultAutoscaleService
extends AbstractSingletonService<AutoscaleMethod>
implements AutoscaleService {
    private HashMap<String, AutoscaleMethod> methods;
    private ArrayList<String> methodNames;

    @Override
    public Map<String, AutoscaleMethod> getAutoscaleMethods() {
        return Collections.unmodifiableMap(this.methods());
    }

    @Override
    public List<String> getAutoscaleMethodNames() {
        return Collections.unmodifiableList(this.methodNames());
    }

    @Override
    public AutoscaleMethod getAutoscaleMethod(String name) {
        return this.methods().get(name);
    }

    @Override
    public AutoscaleMethod getDefaultAutoscaleMethod() {
        return this.getAutoscaleMethod("Default");
    }

    @Override
    public DataRange getDefaultIntervalRange(IterableInterval<? extends RealType<?>> interval) {
        return this.getDefaultAutoscaleMethod().getRange(interval);
    }

    @Override
    public DataRange getDefaultRandomAccessRange(RandomAccessibleInterval<? extends RealType<?>> interval) {
        IterableInterval<? extends RealType<?>> newInterval = Views.iterable(interval);
        return this.getDefaultIntervalRange(newInterval);
    }

    public Class<AutoscaleMethod> getPluginType() {
        return AutoscaleMethod.class;
    }

    private Map<? extends String, ? extends AutoscaleMethod> methods() {
        if (this.methods == null) {
            this.initMethods();
        }
        return this.methods;
    }

    private List<? extends String> methodNames() {
        if (this.methodNames == null) {
            this.initMethodNames();
        }
        return this.methodNames;
    }

    private synchronized void initMethods() {
        if (this.methods != null) {
            return;
        }
        HashMap<String, AutoscaleMethod> map = new HashMap<String, AutoscaleMethod>();
        for (AutoscaleMethod method : this.getInstances()) {
            String name = method.getInfo().getName();
            map.put(name, method);
        }
        this.methods = map;
    }

    private synchronized void initMethodNames() {
        if (this.methodNames != null) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (AutoscaleMethod method : this.getInstances()) {
            String name = method.getInfo().getName();
            list.add(name);
        }
        this.methodNames = list;
    }
}

