/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.numeric.integer;

import net.imglib2.img.NativeImg;
import net.imglib2.img.NativeImgFactory;
import net.imglib2.img.basictypeaccess.LongAccess;
import net.imglib2.img.basictypeaccess.array.LongArray;
import net.imglib2.type.numeric.integer.AbstractIntegerBitType;
import net.imglib2.util.Fraction;

public class Unsigned2BitType
extends AbstractIntegerBitType<Unsigned2BitType> {
    private static final long mask = 3L;

    public Unsigned2BitType(NativeImg<Unsigned2BitType, ? extends LongAccess> bitStorage) {
        super(bitStorage, 2);
    }

    public Unsigned2BitType(long value) {
        this((NativeImg<Unsigned2BitType, ? extends LongAccess>)null);
        this.dataAccess = new LongArray(1);
        this.set(value);
    }

    public Unsigned2BitType(LongAccess access) {
        this((NativeImg<Unsigned2BitType, ? extends LongAccess>)null);
        this.dataAccess = access;
    }

    public Unsigned2BitType() {
        this(0L);
    }

    @Override
    public NativeImg<Unsigned2BitType, ? extends LongAccess> createSuitableNativeImg(NativeImgFactory<Unsigned2BitType> storageFactory, long[] dim) {
        NativeImg<Unsigned2BitType, LongAccess> container = storageFactory.createLongInstance(dim, new Fraction(this.getBitsPerPixel(), 64L));
        Unsigned2BitType linkedType = new Unsigned2BitType(container);
        container.setLinkedType(linkedType);
        return container;
    }

    @Override
    public Unsigned2BitType duplicateTypeOnSameNativeImg() {
        return new Unsigned2BitType(this.img);
    }

    @Override
    public long get() {
        return this.dataAccess.getValue((int)(this.i >>> 5)) >>> (int)((this.i & 0x1FL) << 1) & 3L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(long value) {
        int i1 = (int)(this.i >>> 5);
        long shift = this.i << 1 & 0x3FL;
        long bitsToRetain = 3L << (int)shift ^ 0xFFFFFFFFFFFFFFFFL;
        long bitsToSet = (value & 3L) << (int)shift;
        LongAccess longAccess = this.dataAccess;
        synchronized (longAccess) {
            this.dataAccess.setValue(i1, this.dataAccess.getValue(i1) & bitsToRetain | bitsToSet);
        }
    }

    @Override
    public Unsigned2BitType createVariable() {
        return new Unsigned2BitType(0L);
    }

    @Override
    public Unsigned2BitType copy() {
        return new Unsigned2BitType(this.get());
    }
}

