/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.numeric.integer;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.imglib2.img.NativeImg;
import net.imglib2.img.NativeImgFactory;
import net.imglib2.img.basictypeaccess.LongAccess;
import net.imglib2.img.basictypeaccess.array.LongArray;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.integer.AbstractIntegerType;
import net.imglib2.type.numeric.integer.UnsignedLongType;
import net.imglib2.util.Fraction;

public class Unsigned128BitType
extends AbstractIntegerType<Unsigned128BitType>
implements NativeType<Unsigned128BitType> {
    private int i = 0;
    protected final NativeImg<Unsigned128BitType, ? extends LongAccess> img;
    protected final byte[] bytes = new byte[17];
    protected LongAccess dataAccess;

    public Unsigned128BitType(NativeImg<Unsigned128BitType, ? extends LongAccess> bitStorage) {
        this.img = bitStorage;
    }

    public Unsigned128BitType(long lower, long upper) {
        this((NativeImg<Unsigned128BitType, ? extends LongAccess>)null);
        this.dataAccess = new LongArray(2);
        this.set(lower, upper);
    }

    public Unsigned128BitType(BigInteger value) {
        this((NativeImg<Unsigned128BitType, ? extends LongAccess>)null);
        this.dataAccess = new LongArray(2);
        this.set(value);
    }

    public Unsigned128BitType(LongAccess access) {
        this((NativeImg<Unsigned128BitType, ? extends LongAccess>)null);
        this.dataAccess = access;
    }

    public Unsigned128BitType() {
        this(0L, 0L);
    }

    @Override
    public NativeImg<Unsigned128BitType, ? extends LongAccess> createSuitableNativeImg(NativeImgFactory<Unsigned128BitType> storageFactory, long[] dim) {
        NativeImg<Unsigned128BitType, LongAccess> container = storageFactory.createLongInstance(dim, new Fraction(2L, 1L));
        Unsigned128BitType linkedType = new Unsigned128BitType(container);
        container.setLinkedType(linkedType);
        return container;
    }

    @Override
    public void updateContainer(Object c) {
        this.dataAccess = this.img.update(c);
    }

    @Override
    public Unsigned128BitType duplicateTypeOnSameNativeImg() {
        return new Unsigned128BitType(this.img);
    }

    private final void intoBytes(long lower, long upper) {
        this.bytes[0] = 0;
        this.bytes[1] = (byte)(upper >>> 56 & 0xFFL);
        this.bytes[2] = (byte)(upper >>> 48 & 0xFFL);
        this.bytes[3] = (byte)(upper >>> 40 & 0xFFL);
        this.bytes[4] = (byte)(upper >>> 32 & 0xFFL);
        this.bytes[5] = (byte)(upper >>> 24 & 0xFFL);
        this.bytes[6] = (byte)(upper >>> 16 & 0xFFL);
        this.bytes[7] = (byte)(upper >>> 8 & 0xFFL);
        this.bytes[8] = (byte)(upper & 0xFFL);
        this.bytes[9] = (byte)(lower >>> 56 & 0xFFL);
        this.bytes[10] = (byte)(lower >>> 48 & 0xFFL);
        this.bytes[11] = (byte)(lower >>> 40 & 0xFFL);
        this.bytes[12] = (byte)(lower >>> 32 & 0xFFL);
        this.bytes[13] = (byte)(lower >>> 24 & 0xFFL);
        this.bytes[14] = (byte)(lower >>> 16 & 0xFFL);
        this.bytes[15] = (byte)(lower >>> 8 & 0xFFL);
        this.bytes[16] = (byte)(lower & 0xFFL);
    }

    @Override
    public void set(byte[] bytes) {
        int k = this.i * 2;
        int b = bytes.length - 1;
        for (int offset = 0; offset < 2; ++offset) {
            int cut = Math.max(-1, b - 8);
            long u = 0L;
            int p = 0;
            while (b > cut) {
                u |= ((long)bytes[b] & 0xFFL) << p;
                --b;
                p += 8;
            }
            this.dataAccess.setValue(k + offset, u);
        }
    }

    public BigInteger get() {
        int k = this.i * 2;
        this.intoBytes(this.dataAccess.getValue(k), this.dataAccess.getValue(k + 1));
        return new BigInteger(this.bytes);
    }

    @Override
    public void set(BigInteger value) {
        this.set(value.toByteArray());
    }

    public void set(long lower, long upper) {
        int k = this.i * 2;
        this.dataAccess.setValue(k, lower);
        this.dataAccess.setValue(k + 1, upper);
    }

    @Override
    public int getInteger() {
        return (int)(this.dataAccess.getValue(this.i * 2) & 0xFFFFFFFFL);
    }

    @Override
    public long getIntegerLong() {
        return this.dataAccess.getValue(this.i * 2);
    }

    @Override
    public BigInteger getBigInteger() {
        return this.get();
    }

    @Override
    public void setInteger(int value) {
        int k = this.i * 2;
        this.dataAccess.setValue(k, value);
        this.dataAccess.setValue(k + 1, 0L);
    }

    @Override
    public void setInteger(long value) {
        int k = this.i * 2;
        this.dataAccess.setValue(k, value);
        this.dataAccess.setValue(k + 1, 0L);
    }

    @Override
    public void setBigInteger(BigInteger b) {
        this.set(b);
    }

    @Override
    public double getMaxValue() {
        return Math.pow(2.0, 128.0) - 1.0;
    }

    public BigInteger getMaxBigIntegerValue() {
        this.bytes[0] = 0;
        for (int b = 1; b < this.bytes.length; ++b) {
            this.bytes[b] = -1;
        }
        return new BigInteger(this.bytes);
    }

    @Override
    public double getMinValue() {
        return 0.0;
    }

    @Override
    public int getIndex() {
        return this.i;
    }

    @Override
    public void updateIndex(int index) {
        this.i = index;
    }

    @Override
    public void incIndex() {
        ++this.i;
    }

    @Override
    public void incIndex(int increment) {
        this.i += increment;
    }

    @Override
    public void decIndex() {
        --this.i;
    }

    @Override
    public void decIndex(int decrement) {
        this.i -= decrement;
    }

    @Override
    public Unsigned128BitType createVariable() {
        return new Unsigned128BitType();
    }

    @Override
    public Unsigned128BitType copy() {
        Unsigned128BitType copy = new Unsigned128BitType();
        int k = this.i * 2;
        copy.set(this.dataAccess.getValue(k), this.dataAccess.getValue(k + 1));
        return copy;
    }

    @Override
    public Fraction getEntitiesPerPixel() {
        return new Fraction(2L, 1L);
    }

    @Override
    public int getBitsPerPixel() {
        return 128;
    }

    @Override
    public void inc() {
        int k = this.i * 2;
        long lower = this.dataAccess.getValue(k);
        if (-1L == lower) {
            this.dataAccess.setValue(k, 0L);
            long upper = this.dataAccess.getValue(k + 1);
            if (-1L == upper) {
                this.dataAccess.setValue(k + 1, 0L);
            } else {
                this.dataAccess.setValue(k + 1, upper + 1L);
            }
        } else {
            this.dataAccess.setValue(k, lower + 1L);
        }
    }

    @Override
    public void dec() {
        int k = this.i * 2;
        long lower = this.dataAccess.getValue(k);
        if (0L == lower) {
            this.dataAccess.setValue(k, -1L);
            long upper = this.dataAccess.getValue(k + 1);
            if (0L == upper) {
                this.dataAccess.setValue(k + 1, -1L);
            } else {
                this.dataAccess.setValue(k + 1, upper - 1L);
            }
        } else {
            this.dataAccess.setValue(k, lower - 1L);
        }
    }

    @Override
    public void setZero() {
        this.set(0L, 0L);
    }

    @Override
    public void setOne() {
        this.set(1L, 0L);
    }

    @Override
    public void mul(float c) {
        this.mul((double)c);
    }

    @Override
    public void mul(double c) {
        this.set(new BigDecimal(this.get()).multiply(new BigDecimal(c)).toBigInteger());
    }

    @Override
    public void add(Unsigned128BitType t) {
        this.set(this.get().add(t.get()).toByteArray());
    }

    @Override
    public void sub(Unsigned128BitType t) {
        this.set(this.get().subtract(t.get()).toByteArray());
    }

    @Override
    public void mul(Unsigned128BitType t) {
        this.set(this.get().multiply(t.get()).toByteArray());
    }

    @Override
    public void div(Unsigned128BitType t) {
        this.set(this.get().divide(t.get()).toByteArray());
    }

    @Override
    public int compareTo(Unsigned128BitType t) {
        long upper2;
        long upper1 = this.dataAccess.getValue(this.i * 2 + 1);
        if (-1 == UnsignedLongType.compare(upper1, upper2 = t.dataAccess.getValue(t.i * 2 + 1))) {
            return -1;
        }
        if (upper1 == upper2) {
            long lower1 = this.dataAccess.getValue(this.i * 2);
            long lower2 = t.dataAccess.getValue(t.i * 2);
            return UnsignedLongType.compare(lower1, lower2);
        }
        return 1;
    }

    @Override
    public boolean valueEquals(Unsigned128BitType t) {
        int k = this.i * 2;
        int kt = t.i * 2;
        return this.dataAccess.getValue(k) == t.dataAccess.getValue(kt) && this.dataAccess.getValue(k + 1) == t.dataAccess.getValue(kt + 1);
    }
}

