/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.numeric.complex;

import net.imglib2.img.NativeImg;
import net.imglib2.img.NativeImgFactory;
import net.imglib2.img.basictypeaccess.FloatAccess;
import net.imglib2.img.basictypeaccess.array.FloatArray;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.complex.AbstractComplexType;
import net.imglib2.util.Fraction;

public class ComplexFloatType
extends AbstractComplexType<ComplexFloatType>
implements NativeType<ComplexFloatType> {
    private int i = 0;
    private int realI = 0;
    private int imaginaryI = 1;
    protected final NativeImg<ComplexFloatType, ? extends FloatAccess> img;
    protected FloatAccess dataAccess;

    public ComplexFloatType(NativeImg<ComplexFloatType, ? extends FloatAccess> complexfloatStorage) {
        this.img = complexfloatStorage;
    }

    public ComplexFloatType(float r, float i) {
        this.img = null;
        this.dataAccess = new FloatArray(2);
        this.set(r, i);
    }

    public ComplexFloatType(FloatAccess access) {
        this.img = null;
        this.dataAccess = access;
    }

    public ComplexFloatType() {
        this(0.0f, 0.0f);
    }

    @Override
    public NativeImg<ComplexFloatType, ? extends FloatAccess> createSuitableNativeImg(NativeImgFactory<ComplexFloatType> storageFactory, long[] dim) {
        NativeImg<ComplexFloatType, FloatAccess> container = storageFactory.createFloatInstance(dim, new Fraction(2L, 1L));
        ComplexFloatType linkedType = new ComplexFloatType(container);
        container.setLinkedType(linkedType);
        return container;
    }

    @Override
    public void updateContainer(Object c) {
        this.dataAccess = this.img.update(c);
    }

    @Override
    public ComplexFloatType duplicateTypeOnSameNativeImg() {
        return new ComplexFloatType(this.img);
    }

    @Override
    public float getRealFloat() {
        return this.dataAccess.getValue(this.realI);
    }

    @Override
    public double getRealDouble() {
        return this.dataAccess.getValue(this.realI);
    }

    @Override
    public float getImaginaryFloat() {
        return this.dataAccess.getValue(this.imaginaryI);
    }

    @Override
    public double getImaginaryDouble() {
        return this.dataAccess.getValue(this.imaginaryI);
    }

    @Override
    public void setReal(float r) {
        this.dataAccess.setValue(this.realI, r);
    }

    @Override
    public void setReal(double r) {
        this.dataAccess.setValue(this.realI, (float)r);
    }

    @Override
    public void setImaginary(float i) {
        this.dataAccess.setValue(this.imaginaryI, i);
    }

    @Override
    public void setImaginary(double i) {
        this.dataAccess.setValue(this.imaginaryI, (float)i);
    }

    public void set(float r, float i) {
        this.dataAccess.setValue(this.realI, r);
        this.dataAccess.setValue(this.imaginaryI, i);
    }

    @Override
    public void add(ComplexFloatType c) {
        this.setReal(this.getRealFloat() + c.getRealFloat());
        this.setImaginary(this.getImaginaryFloat() + c.getImaginaryFloat());
    }

    @Override
    public void div(ComplexFloatType c) {
        float a1 = this.getRealFloat();
        float b1 = this.getImaginaryFloat();
        float c1 = c.getRealFloat();
        float d1 = c.getImaginaryFloat();
        this.setReal((a1 * c1 + b1 * d1) / (c1 * c1 + d1 * d1));
        this.setImaginary((b1 * c1 - a1 * d1) / (c1 * c1 + d1 * d1));
    }

    @Override
    public void mul(ComplexFloatType t) {
        float a = this.getRealFloat();
        float b = this.getImaginaryFloat();
        float c = t.getRealFloat();
        float d = t.getImaginaryFloat();
        this.setReal(a * c - b * d);
        this.setImaginary(a * d + b * c);
    }

    @Override
    public void sub(ComplexFloatType c) {
        this.setReal(this.getRealFloat() - c.getRealFloat());
        this.setImaginary(this.getImaginaryFloat() - c.getImaginaryFloat());
    }

    @Override
    public void complexConjugate() {
        this.setImaginary(-this.getImaginaryFloat());
    }

    public void switchRealComplex() {
        float a = this.getRealFloat();
        this.setReal(this.getImaginaryFloat());
        this.setImaginary(a);
    }

    @Override
    public void set(ComplexFloatType c) {
        this.setReal(c.getRealFloat());
        this.setImaginary(c.getImaginaryFloat());
    }

    @Override
    public ComplexFloatType createVariable() {
        return new ComplexFloatType(0.0f, 0.0f);
    }

    @Override
    public ComplexFloatType copy() {
        return new ComplexFloatType(this.getRealFloat(), this.getImaginaryFloat());
    }

    @Override
    public Fraction getEntitiesPerPixel() {
        return new Fraction(2L, 1L);
    }

    @Override
    public void updateIndex(int index) {
        this.i = index;
        this.realI = index * 2;
        this.imaginaryI = index * 2 + 1;
    }

    @Override
    public void incIndex() {
        ++this.i;
        this.realI += 2;
        this.imaginaryI += 2;
    }

    @Override
    public void incIndex(int increment) {
        this.i += increment;
        int inc2 = 2 * increment;
        this.realI += inc2;
        this.imaginaryI += inc2;
    }

    @Override
    public void decIndex() {
        --this.i;
        this.realI -= 2;
        this.imaginaryI -= 2;
    }

    @Override
    public void decIndex(int decrement) {
        this.i -= decrement;
        int dec2 = 2 * decrement;
        this.realI -= dec2;
        this.imaginaryI -= dec2;
    }

    @Override
    public int getIndex() {
        return this.i;
    }

    @Override
    public boolean valueEquals(ComplexFloatType t) {
        return this.getRealFloat() == t.getRealFloat() && this.getImaginaryFloat() == t.getImaginaryFloat();
    }
}

