/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.numeric;

import net.imglib2.type.numeric.NumericType;
import net.imglib2.util.Util;

public abstract class AbstractARGBDoubleType<T extends AbstractARGBDoubleType<T>>
implements NumericType<T> {
    public abstract double getA();

    public abstract double getR();

    public abstract double getG();

    public abstract double getB();

    public abstract void setA(double var1);

    public abstract void setR(double var1);

    public abstract void setG(double var1);

    public abstract void setB(double var1);

    public void set(double a, double r, double g, double b) {
        this.setA(a);
        this.setR(r);
        this.setG(g);
        this.setB(b);
    }

    @Override
    public void set(T c) {
        this.set(((AbstractARGBDoubleType)c).getA(), ((AbstractARGBDoubleType)c).getR(), ((AbstractARGBDoubleType)c).getG(), ((AbstractARGBDoubleType)c).getB());
    }

    @Override
    public void add(T c) {
        this.set(this.getA() + ((AbstractARGBDoubleType)c).getA(), this.getR() + ((AbstractARGBDoubleType)c).getR(), this.getG() + ((AbstractARGBDoubleType)c).getG(), this.getB() + ((AbstractARGBDoubleType)c).getB());
    }

    @Override
    public void sub(T c) {
        this.set(this.getA() - ((AbstractARGBDoubleType)c).getA(), this.getR() - ((AbstractARGBDoubleType)c).getR(), this.getG() - ((AbstractARGBDoubleType)c).getG(), this.getB() - ((AbstractARGBDoubleType)c).getB());
    }

    @Override
    public void mul(T c) {
        this.set(this.getA() * ((AbstractARGBDoubleType)c).getA(), this.getR() * ((AbstractARGBDoubleType)c).getR(), this.getG() * ((AbstractARGBDoubleType)c).getG(), this.getB() * ((AbstractARGBDoubleType)c).getB());
    }

    @Override
    public void div(T c) {
        this.set(this.getA() / ((AbstractARGBDoubleType)c).getA(), this.getR() / ((AbstractARGBDoubleType)c).getR(), this.getG() / ((AbstractARGBDoubleType)c).getG(), this.getB() / ((AbstractARGBDoubleType)c).getB());
    }

    @Override
    public void setZero() {
        this.set(0.0, 0.0, 0.0, 0.0);
    }

    @Override
    public void setOne() {
        this.set(1.0, 1.0, 1.0, 1.0);
    }

    @Override
    public void mul(float c) {
        this.set(this.getA() * (double)c, this.getR() * (double)c, this.getG() * (double)c, this.getB() * (double)c);
    }

    @Override
    public void mul(double c) {
        this.set(this.getA() * c, this.getR() * c, this.getG() * c, this.getB() * c);
    }

    public int toARGBInt() {
        int a = (int)Math.max(0L, Math.min(255L, Util.round(this.getA() * 255.0)));
        int r = (int)Math.max(0L, Math.min(255L, Util.round(this.getR() * 255.0)));
        int g = (int)Math.max(0L, Math.min(255L, Util.round(this.getG() * 255.0)));
        int b = (int)Math.max(0L, Math.min(255L, Util.round(this.getB() * 255.0)));
        return ((a << 8 | r) << 8 | g) << 8 | b;
    }

    @Override
    public boolean valueEquals(T t) {
        return this.getA() == ((AbstractARGBDoubleType)t).getA() && this.getR() == ((AbstractARGBDoubleType)t).getR() && this.getG() == ((AbstractARGBDoubleType)t).getG() && this.getB() == ((AbstractARGBDoubleType)t).getB();
    }
}

