/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.cell;

import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;
import net.imglib2.img.basictypeaccess.array.ByteArray;
import net.imglib2.img.basictypeaccess.array.CharArray;
import net.imglib2.img.basictypeaccess.array.DoubleArray;
import net.imglib2.img.basictypeaccess.array.FloatArray;
import net.imglib2.img.basictypeaccess.array.IntArray;
import net.imglib2.img.basictypeaccess.array.LongArray;
import net.imglib2.img.basictypeaccess.array.ShortArray;
import net.imglib2.img.cell.AbstractCellImgFactory;
import net.imglib2.img.cell.CellImg;
import net.imglib2.img.cell.DefaultCell;
import net.imglib2.img.cell.ListImgCells;
import net.imglib2.type.NativeType;
import net.imglib2.util.Fraction;

public final class CellImgFactory<T extends NativeType<T>>
extends AbstractCellImgFactory<T> {
    public CellImgFactory() {
    }

    public CellImgFactory(int cellSize) {
        super(cellSize);
    }

    public CellImgFactory(int[] cellDimensions) {
        super(cellDimensions);
    }

    public CellImg<T, ?, ?> create(long[] dim, T type) {
        return (CellImg)type.createSuitableNativeImg(this, dim);
    }

    public CellImg<T, ByteArray, DefaultCell<ByteArray>> createByteInstance(long[] dimensions, Fraction entitiesPerPixel) {
        return this.createInstance(new ByteArray(1), dimensions, entitiesPerPixel);
    }

    public CellImg<T, CharArray, DefaultCell<CharArray>> createCharInstance(long[] dimensions, Fraction entitiesPerPixel) {
        return this.createInstance(new CharArray(1), dimensions, entitiesPerPixel);
    }

    public CellImg<T, ShortArray, DefaultCell<ShortArray>> createShortInstance(long[] dimensions, Fraction entitiesPerPixel) {
        return this.createInstance(new ShortArray(1), dimensions, entitiesPerPixel);
    }

    public CellImg<T, IntArray, DefaultCell<IntArray>> createIntInstance(long[] dimensions, Fraction entitiesPerPixel) {
        return this.createInstance(new IntArray(1), dimensions, entitiesPerPixel);
    }

    public CellImg<T, LongArray, DefaultCell<LongArray>> createLongInstance(long[] dimensions, Fraction entitiesPerPixel) {
        return this.createInstance(new LongArray(1), dimensions, entitiesPerPixel);
    }

    public CellImg<T, FloatArray, DefaultCell<FloatArray>> createFloatInstance(long[] dimensions, Fraction entitiesPerPixel) {
        return this.createInstance(new FloatArray(1), dimensions, entitiesPerPixel);
    }

    public CellImg<T, DoubleArray, DefaultCell<DoubleArray>> createDoubleInstance(long[] dimensions, Fraction entitiesPerPixel) {
        return this.createInstance(new DoubleArray(1), dimensions, entitiesPerPixel);
    }

    @Override
    public <S> ImgFactory<S> imgFactory(S type) throws IncompatibleTypeException {
        if (NativeType.class.isInstance(type)) {
            return new CellImgFactory<T>(this.defaultCellDimensions);
        }
        throw new IncompatibleTypeException(this, type.getClass().getCanonicalName() + " does not implement NativeType.");
    }

    private <A extends ArrayDataAccess<A>> CellImg<T, A, DefaultCell<A>> createInstance(A array, long[] dimensions, Fraction entitiesPerPixel) {
        dimensions = this.checkDimensions(dimensions);
        int[] cellSize = this.checkCellSize(this.defaultCellDimensions, dimensions);
        return new CellImg(this, new ListImgCells<A>(array, entitiesPerPixel, dimensions, cellSize));
    }
}

