/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.cell;

import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.cell.AbstractCell;
import net.imglib2.img.cell.Cells;
import net.imglib2.util.Fraction;

public abstract class AbstractCells<A, C extends AbstractCell<A>, I extends RandomAccessibleInterval<C> & IterableInterval<C>>
implements Cells<A, C> {
    protected final Fraction entitiesPerPixel;
    protected final int n;
    protected final long[] dimensions;
    protected final int[] cellDimensions;
    protected final long[] numCells;
    protected final int[] borderSize;

    public AbstractCells(Fraction entitiesPerPixel, long[] dimensions, int[] cellDimensions) {
        this.entitiesPerPixel = entitiesPerPixel;
        this.n = dimensions.length;
        this.dimensions = (long[])dimensions.clone();
        this.cellDimensions = (int[])cellDimensions.clone();
        this.numCells = new long[this.n];
        this.borderSize = new int[this.n];
        for (int d = 0; d < this.n; ++d) {
            this.numCells[d] = (dimensions[d] - 1L) / (long)cellDimensions[d] + 1L;
            this.borderSize[d] = (int)(dimensions[d] - (this.numCells[d] - 1L) * (long)cellDimensions[d]);
        }
    }

    protected abstract I cells();

    protected void getCellDimensions(long[] cellGridPosition, long[] cellMin, int[] cellDims) {
        for (int d = 0; d < this.n; ++d) {
            cellDims[d] = cellGridPosition[d] + 1L == this.numCells[d] ? this.borderSize[d] : this.cellDimensions[d];
            cellMin[d] = cellGridPosition[d] * (long)this.cellDimensions[d];
        }
    }

    @Override
    public RandomAccess<C> randomAccess() {
        return this.cells().randomAccess();
    }

    @Override
    public Cursor<C> cursor() {
        return ((IterableInterval)this.cells()).cursor();
    }

    @Override
    public Cursor<C> localizingCursor() {
        return ((IterableInterval)this.cells()).localizingCursor();
    }

    @Override
    public int numDimensions() {
        return this.n;
    }

    @Override
    public void dimensions(long[] s) {
        for (int i = 0; i < this.n; ++i) {
            s[i] = this.dimensions[i];
        }
    }

    @Override
    public long dimension(int d) {
        return this.dimensions[d];
    }

    @Override
    public void cellDimensions(int[] s) {
        for (int i = 0; i < this.n; ++i) {
            s[i] = this.cellDimensions[i];
        }
    }

    @Override
    public int cellDimension(int d) {
        return this.cellDimensions[d];
    }

    @Override
    public Fraction getEntitiesPerPixel() {
        return this.entitiesPerPixel;
    }
}

