/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.cell;

import net.imglib2.img.NativeImgFactory;
import net.imglib2.type.NativeType;

public abstract class AbstractCellImgFactory<T extends NativeType<T>>
extends NativeImgFactory<T> {
    protected int[] defaultCellDimensions = new int[]{10};

    public AbstractCellImgFactory() {
    }

    public AbstractCellImgFactory(int cellSize) {
        this.defaultCellDimensions[0] = cellSize;
    }

    public AbstractCellImgFactory(int[] cellDimensions) {
        if (cellDimensions == null || cellDimensions.length == 0) {
            System.err.println("CellContainerFactory(): cellSize is null. Using equal cell size of " + this.defaultCellDimensions[0]);
            return;
        }
        for (int i = 0; i < cellDimensions.length; ++i) {
            if (cellDimensions[i] > 0) continue;
            System.err.println("CellContainerFactory(): cell size in dimension " + i + " is <= 0, using a size of " + this.defaultCellDimensions[0] + ".");
            cellDimensions[i] = this.defaultCellDimensions[0];
        }
        this.defaultCellDimensions = cellDimensions;
    }

    protected long[] checkDimensions(long[] dimensions) {
        if (dimensions == null || dimensions.length == 0) {
            System.err.println("CellContainerFactory(): dimensionality is null. Creating a 1D cell with size 1.");
            dimensions = new long[]{1L};
        }
        for (int i = 0; i < dimensions.length; ++i) {
            if (dimensions[i] > 0L) continue;
            System.err.println("CellContainerFactory(): size of dimension " + i + " is <= 0, using a size of 1.");
            dimensions[i] = 1L;
        }
        return dimensions;
    }

    protected int[] checkCellSize(int[] cellDimensions, long[] dimensions) {
        if (cellDimensions == null) {
            cellDimensions = new int[dimensions.length];
            for (int i = 0; i < cellDimensions.length; ++i) {
                cellDimensions[i] = this.defaultCellDimensions[i < this.defaultCellDimensions.length ? i : 0];
            }
        }
        if (cellDimensions.length != dimensions.length) {
            int[] cellDimensionsNew = new int[dimensions.length];
            for (int i = 0; i < dimensions.length; ++i) {
                cellDimensionsNew[i] = i < cellDimensions.length ? cellDimensions[i] : this.defaultCellDimensions[i < this.defaultCellDimensions.length ? i : 0];
            }
            cellDimensions = cellDimensionsNew;
        }
        return cellDimensions;
    }
}

