/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.array;

import net.imglib2.AbstractLocalizingCursorInt;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.type.NativeType;
import net.imglib2.util.IntervalIndexer;

public abstract class AbstractArrayLocalizingCursor<T extends NativeType<T>>
extends AbstractLocalizingCursorInt<T> {
    protected final int size;
    protected final int offset;
    protected final T type;
    protected final ArrayImg<T, ?> img;
    protected final int lastIndex;
    protected final int[] max;

    protected AbstractArrayLocalizingCursor(AbstractArrayLocalizingCursor<T> cursor) {
        super(cursor.numDimensions());
        this.img = cursor.img;
        this.type = this.img.createLinkedType();
        this.offset = cursor.offset;
        this.size = cursor.size;
        this.lastIndex = this.offset + this.size - 1;
        this.max = new int[this.n];
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = cursor.position[d];
            this.max[d] = cursor.max[d];
        }
        this.type.updateIndex(cursor.type.getIndex());
        this.type.updateContainer(this);
        this.reset();
    }

    public AbstractArrayLocalizingCursor(ArrayImg<T, ?> img, int offset, int size) {
        super(img.numDimensions());
        this.img = img;
        this.offset = offset;
        this.size = size;
        this.type = img.createLinkedType();
        this.lastIndex = offset + size - 1;
        this.max = new int[this.n];
        for (int d = 0; d < this.n; ++d) {
            this.max[d] = (int)img.max(d);
        }
        this.reset();
    }

    @Override
    public T get() {
        return this.type;
    }

    @Override
    public boolean hasNext() {
        return this.type.getIndex() < this.lastIndex;
    }

    @Override
    public void fwd() {
        this.type.incIndex();
        this.position[0] = this.position[0] + 1;
        if (this.position[0] <= this.max[0]) {
            return;
        }
        this.position[0] = 0;
        for (int d = 1; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + 1;
            if (this.position[n] <= this.max[d]) break;
            this.position[d] = 0;
        }
    }

    @Override
    public void jumpFwd(long steps) {
        this.type.incIndex((int)steps);
        IntervalIndexer.indexToPosition(this.type.getIndex(), this.img.dim, this.position);
    }

    @Override
    public void reset() {
        this.type.updateIndex(this.offset - 1);
        IntervalIndexer.indexToPosition(this.offset, this.img.dim, this.position);
        this.position[0] = this.position[0] - 1;
        this.type.updateContainer(this);
    }
}

