/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.geom.geom2d;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.imagej.ops.Ops;
import net.imagej.ops.special.function.AbstractUnaryFunctionOp;
import net.imglib2.RealLocalizable;
import net.imglib2.roi.geometric.Polygon;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.util.Pair;
import net.imglib2.util.ValuePair;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Geometric.SecondMoment.class)
public class DefaultMinorMajorAxis
extends AbstractUnaryFunctionOp<Polygon, Pair<DoubleType, DoubleType>>
implements Ops.Geometric.SecondMoment {
    private double[] getMinorMajorAxis(Polygon input, List<RealLocalizable> points) {
        double ta;
        double[] moments = this.getMoments(input, points);
        double m00 = moments[0];
        double u02 = moments[3];
        double u20 = moments[1];
        double u11 = moments[2];
        double m4 = 4.0 * Math.abs(u02 * u20 - u11 * u11);
        if (m4 < 1.0E-6) {
            m4 = 1.0E-6;
        }
        double a11 = u02 / m4;
        double a12 = u11 / m4;
        double a22 = u20 / m4;
        double tmp = a11 - a22;
        if (tmp == 0.0) {
            tmp = 1.0E-6;
        }
        if ((ta = 0.5 * Math.atan(2.0 * a12 / tmp)) < 0.0) {
            ta += 1.5707963267948966;
        }
        if (a12 > 0.0) {
            ta += 1.5707963267948966;
        } else if (a12 == 0.0) {
            if (a22 > a11) {
                ta = 0.0;
                tmp = a22;
                a22 = a11;
                a11 = tmp;
            } else if (a11 != a22) {
                ta = 1.5707963267948966;
            }
        }
        tmp = Math.sin(ta);
        if (tmp == 0.0) {
            tmp = 1.0E-6;
        }
        double z = a12 * Math.cos(ta) / tmp;
        double major = Math.sqrt(1.0 / Math.abs(a22 + z));
        double minor = Math.sqrt(1.0 / Math.abs(a11 - z));
        double scale = Math.sqrt(m00 / (Math.PI * major * minor));
        major = major * scale * 2.0;
        minor = minor * scale * 2.0;
        double angle = 180.0 * ta / Math.PI;
        if (angle == 180.0) {
            angle = 0.0;
        }
        if (major < minor) {
            tmp = major;
            major = minor;
            minor = tmp;
        }
        return new double[]{minor, major};
    }

    private double[] getMoments(Polygon input, List<RealLocalizable> points) {
        double m00 = 0.0;
        double m01 = 0.0;
        double m02 = 0.0;
        double m10 = 0.0;
        double m11 = 0.0;
        double m20 = 0.0;
        for (int i = 1; i < points.size(); ++i) {
            double a = this.getX(input, i - 1) * this.getY(input, i) - this.getX(input, i) * this.getY(input, i - 1);
            m00 += a;
            m10 += a * (this.getX(input, i - 1) + this.getX(input, i));
            m01 += a * (this.getY(input, i - 1) + this.getY(input, i));
            m20 += a * (Math.pow(this.getX(input, i - 1), 2.0) + this.getX(input, i - 1) * this.getX(input, i) + Math.pow(this.getX(input, i), 2.0));
            m11 += a * (2.0 * this.getX(input, i - 1) * this.getY(input, i - 1) + this.getX(input, i - 1) * this.getY(input, i) + this.getX(input, i) * this.getY(input, i - 1) + 2.0 * this.getX(input, i) * this.getY(input, i));
            m02 += a * (Math.pow(this.getY(input, i - 1), 2.0) + this.getY(input, i - 1) * this.getY(input, i) + Math.pow(this.getY(input, i), 2.0));
        }
        double n20 = (m20 /= 12.0 * m00) - Math.pow(m10 /= 6.0 * m00, 2.0);
        double n11 = (m11 /= 24.0 * m00) - m10 * (m01 /= 6.0 * (m00 /= 2.0));
        double n02 = (m02 /= 12.0 * m00) - Math.pow(m01, 2.0);
        return new double[]{m00, n20, n11, n02};
    }

    private double getY(Polygon input, int index) {
        int i = index;
        if (i == input.getVertices().size()) {
            i = 0;
        }
        return input.getVertices().get(i).getDoublePosition(1);
    }

    private double getX(Polygon input, int index) {
        int i = index;
        if (i == input.getVertices().size()) {
            i = 0;
        }
        return input.getVertices().get(i).getDoublePosition(0);
    }

    @Override
    public Pair<DoubleType, DoubleType> calculate(Polygon input) {
        ArrayList<RealLocalizable> points = new ArrayList<RealLocalizable>(input.getVertices());
        Collections.sort(points, new Comparator<RealLocalizable>(){

            @Override
            public int compare(RealLocalizable o1, RealLocalizable o2) {
                Double o1x = new Double(o1.getDoublePosition(0));
                Double o2x = new Double(o2.getDoublePosition(0));
                int result = o2x.compareTo(o1x);
                if (result == 0) {
                    return new Double(o2.getDoublePosition(1)).compareTo(new Double(o1.getDoublePosition(1)));
                }
                return result;
            }
        });
        points.add((RealLocalizable)points.get(0));
        double[] minorMajorAxis = this.getMinorMajorAxis(input, points);
        return new ValuePair((Object)new DoubleType(minorMajorAxis[0]), (Object)new DoubleType(minorMajorAxis[1]));
    }
}

