/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.geom.geom2d;

import java.util.List;
import net.imagej.ops.Ops;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imagej.ops.special.hybrid.AbstractUnaryHybridCF;
import net.imglib2.RealLocalizable;
import net.imglib2.roi.geometric.Polygon;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Geometric.FeretsDiameter.class)
public class DefaultFeretsDiameterForAngle
extends AbstractUnaryHybridCF<Polygon, DoubleType>
implements Ops.Geometric.FeretsDiameter {
    @Parameter
    private double angle = 0.0;
    private UnaryFunctionOp<Polygon, Polygon> function;

    @Override
    public void initialize() {
        this.function = Functions.unary(this.ops(), Ops.Geometric.ConvexHull.class, Polygon.class, this.in(), new Object[0]);
    }

    @Override
    public void compute(Polygon input, DoubleType output) {
        List<? extends RealLocalizable> points = this.function.calculate(input).getVertices();
        double angleRad = -this.angle * Math.PI / 180.0;
        double minX = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        for (RealLocalizable realLocalizable : points) {
            double tmpX = realLocalizable.getDoublePosition(0) * Math.cos(angleRad) - realLocalizable.getDoublePosition(1) * Math.sin(angleRad);
            minX = tmpX < minX ? tmpX : minX;
            maxX = tmpX > maxX ? tmpX : maxX;
        }
        output.set(Math.abs(maxX - minX));
    }

    @Override
    public DoubleType createOutput(Polygon input) {
        return new DoubleType();
    }
}

