/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.geom.geom2d;

import java.util.List;
import net.imagej.ops.Ops;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imagej.ops.special.hybrid.AbstractUnaryHybridCF;
import net.imglib2.RealLocalizable;
import net.imglib2.roi.geometric.Polygon;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Geometric.MainElongation.class, label="Geometric (2D): Elongation")
public class DefaultElongation
extends AbstractUnaryHybridCF<Polygon, DoubleType>
implements Ops.Geometric.MainElongation {
    private UnaryFunctionOp<Polygon, Polygon> minimumBoundingBoxFunc;

    @Override
    public void initialize() {
        this.minimumBoundingBoxFunc = Functions.unary(this.ops(), Ops.Geometric.SmallestEnclosingBoundingBox.class, Polygon.class, this.in(), new Object[0]);
    }

    @Override
    public void compute(Polygon input, DoubleType output) {
        double length;
        List<? extends RealLocalizable> minBB = this.minimumBoundingBoxFunc.calculate(input).getVertices();
        RealLocalizable p1 = minBB.get(0);
        RealLocalizable p2 = minBB.get(1);
        RealLocalizable p3 = minBB.get(2);
        double width = Math.sqrt(Math.pow(p1.getDoublePosition(0) - p2.getDoublePosition(0), 2.0) + Math.pow(p1.getDoublePosition(1) - p2.getDoublePosition(1), 2.0));
        if (width > (length = Math.sqrt(Math.pow(p2.getDoublePosition(0) - p3.getDoublePosition(0), 2.0) + Math.pow(p2.getDoublePosition(1) - p3.getDoublePosition(1), 2.0)))) {
            double tmp = width;
            width = length;
            length = tmp;
        }
        output.set(1.0 - width / length);
    }

    @Override
    public DoubleType createOutput(Polygon input) {
        return new DoubleType();
    }
}

