/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.filter.fftSize;

import net.imagej.ops.Ops;
import net.imagej.ops.special.function.AbstractUnaryFunctionOp;
import net.imglib2.Dimensions;
import net.imglib2.algorithm.fft2.FFTMethods;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Filter.FFTSize.class)
public class ComputeFFTMethodsSize
extends AbstractUnaryFunctionOp<Dimensions, long[][]>
implements Ops.Filter.FFTSize {
    @Parameter
    private boolean forward;
    @Parameter
    private boolean fast;

    @Override
    public long[][] calculate(Dimensions inputDimensions) {
        long[][] size = new long[][]{new long[inputDimensions.numDimensions()], new long[inputDimensions.numDimensions()]};
        if (this.fast && this.forward) {
            FFTMethods.dimensionsRealToComplexFast((Dimensions)inputDimensions, (long[])size[0], (long[])size[1]);
        } else if (!this.fast && this.forward) {
            FFTMethods.dimensionsRealToComplexSmall((Dimensions)inputDimensions, (long[])size[0], (long[])size[1]);
        }
        if (this.fast && !this.forward) {
            FFTMethods.dimensionsComplexToRealFast((Dimensions)inputDimensions, (long[])size[0], (long[])size[1]);
        } else if (!this.fast && !this.forward) {
            FFTMethods.dimensionsComplexToRealSmall((Dimensions)inputDimensions, (long[])size[0], (long[])size[1]);
        }
        return size;
    }
}

