/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.filter;

import net.imagej.ops.Ops;
import net.imagej.ops.filter.AbstractFFTFilterC;
import net.imagej.ops.filter.fft.FFTMethodsOpC;
import net.imagej.ops.filter.ifft.IFFTMethodsOpC;
import net.imagej.ops.special.computer.BinaryComputerOp;
import net.imagej.ops.special.computer.Computers;
import net.imagej.ops.special.computer.UnaryComputerOp;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.type.numeric.RealType;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Filter.LinearFilter.class, priority=-100.0)
public class FFTMethodsLinearFFTFilterC<I extends RealType<I>, O extends RealType<O>, K extends RealType<K>, C extends ComplexType<C>>
extends AbstractFFTFilterC<RandomAccessibleInterval<I>, RandomAccessibleInterval<O>, RandomAccessibleInterval<K>, RandomAccessibleInterval<C>>
implements Ops.Filter.LinearFilter {
    @Parameter
    private BinaryComputerOp<RandomAccessibleInterval<C>, RandomAccessibleInterval<C>, RandomAccessibleInterval<C>> frequencyOp;
    private UnaryComputerOp<RandomAccessibleInterval<I>, RandomAccessibleInterval<C>> fftIn;
    private UnaryComputerOp<RandomAccessibleInterval<K>, RandomAccessibleInterval<C>> fftKernel;
    private UnaryComputerOp<RandomAccessibleInterval<C>, RandomAccessibleInterval<O>> ifft;

    @Override
    public void initialize() {
        super.initialize();
        this.fftIn = Computers.unary(this.ops(), FFTMethodsOpC.class, this.getFFTInput(), RandomAccessibleInterval.class, new Object[0]);
        this.fftKernel = Computers.unary(this.ops(), FFTMethodsOpC.class, this.getFFTKernel(), RandomAccessibleInterval.class, new Object[0]);
        this.ifft = Computers.unary(this.ops(), IFFTMethodsOpC.class, RandomAccessibleInterval.class, this.getFFTKernel(), new Object[0]);
    }

    @Override
    public void compute(RandomAccessibleInterval<I> in, RandomAccessibleInterval<K> kernel, RandomAccessibleInterval<O> out) {
        if (this.getPerformInputFFT()) {
            this.fftIn.compute((RandomAccessibleInterval<RandomAccessibleInterval<I>>)in, (RandomAccessibleInterval<C>)this.getFFTInput());
        }
        if (this.getPerformKernelFFT()) {
            this.fftKernel.compute(kernel, (RandomAccessibleInterval<C>)this.getFFTKernel());
        }
        this.frequencyOp.compute((RandomAccessibleInterval<C>)this.getFFTInput(), (RandomAccessibleInterval<C>)this.getFFTKernel(), (RandomAccessibleInterval<C>)this.getFFTInput());
        this.ifft.compute((RandomAccessibleInterval<C>)this.getFFTInput(), (RandomAccessibleInterval<RandomAccessibleInterval<O>>)out);
    }
}

