/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.filter;

import net.imagej.ops.filter.fft.CreateOutputFFTMethods;
import net.imagej.ops.filter.pad.PadInputFFTMethods;
import net.imagej.ops.filter.pad.PadShiftKernelFFTMethods;
import net.imagej.ops.special.computer.BinaryComputerOp;
import net.imagej.ops.special.function.AbstractBinaryFunctionOp;
import net.imagej.ops.special.function.BinaryFunctionOp;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.outofbounds.OutOfBoundsMirrorFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.complex.ComplexFloatType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Util;
import org.scijava.plugin.Parameter;

public abstract class AbstractFFTFilterF<I extends RealType<I>, O extends RealType<O> & NativeType<O>, K extends RealType<K>, C extends ComplexType<C> & NativeType<C>>
extends AbstractBinaryFunctionOp<RandomAccessibleInterval<I>, RandomAccessibleInterval<K>, RandomAccessibleInterval<O>> {
    @Parameter(required=false)
    private long[] borderSize = null;
    @Parameter(required=false)
    private OutOfBoundsFactory<I, RandomAccessibleInterval<I>> obfInput;
    @Parameter(required=false)
    private OutOfBoundsFactory<K, RandomAccessibleInterval<K>> obfKernel;
    @Parameter(required=false)
    private Type<O> outType;
    @Parameter(required=false)
    private ComplexType<C> fftType;
    private BinaryFunctionOp<RandomAccessibleInterval<I>, Dimensions, RandomAccessibleInterval<I>> padOp;
    private BinaryFunctionOp<RandomAccessibleInterval<K>, Dimensions, RandomAccessibleInterval<K>> padKernelOp;
    private UnaryFunctionOp<Dimensions, RandomAccessibleInterval<C>> createOp;
    private BinaryComputerOp<RandomAccessibleInterval<I>, RandomAccessibleInterval<K>, RandomAccessibleInterval<O>> filter;

    @Override
    public void initialize() {
        super.initialize();
        if (this.fftType == null) {
            this.fftType = (ComplexType)this.ops().create().nativeType(ComplexFloatType.class);
        }
        if (this.obfInput == null) {
            this.obfInput = new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.SINGLE);
        }
        this.padOp = Functions.binary(this.ops(), PadInputFFTMethods.class, RandomAccessibleInterval.class, RandomAccessibleInterval.class, Dimensions.class, new Object[]{true, this.obfInput});
        this.padKernelOp = Functions.binary(this.ops(), PadShiftKernelFFTMethods.class, RandomAccessibleInterval.class, RandomAccessibleInterval.class, Dimensions.class, new Object[]{true});
        this.createOp = Functions.unary(this.ops(), CreateOutputFFTMethods.class, RandomAccessibleInterval.class, Dimensions.class, new Object[]{this.fftType, true});
    }

    public RandomAccessibleInterval<O> createOutput(RandomAccessibleInterval<I> input, RandomAccessibleInterval<K> kernel) {
        if (this.outType == null) {
            if (((RealType)Util.getTypeFromInterval(input)).getClass() == ((RealType)Util.getTypeFromInterval(kernel)).getClass()) {
                Type temp;
                this.outType = temp = ((RealType)Util.getTypeFromInterval(input)).createVariable();
            } else {
                FloatType temp = new FloatType();
                this.outType = (Type)temp;
            }
        }
        return this.ops().create().img((Dimensions)input, (NativeType)this.outType.createVariable());
    }

    @Override
    public RandomAccessibleInterval<O> calculate(RandomAccessibleInterval<I> input, RandomAccessibleInterval<K> kernel) {
        int d;
        RandomAccessibleInterval<O> output = this.createOutput(input, kernel);
        int numDimensions = input.numDimensions();
        long[] paddedSize = new long[numDimensions];
        if (this.borderSize == null) {
            for (d = 0; d < numDimensions; ++d) {
                paddedSize[d] = (int)input.dimension(d) + (int)kernel.dimension(d) - 1;
            }
        } else {
            for (d = 0; d < numDimensions; ++d) {
                paddedSize[d] = Math.max(kernel.dimension(d) + 2L * this.borderSize[d], input.dimension(d) + 2L * this.borderSize[d]);
            }
        }
        RandomAccessibleInterval<I> paddedInput = this.padOp.calculate(input, (Dimensions)new FinalDimensions(paddedSize));
        RandomAccessibleInterval<K> paddedKernel = this.padKernelOp.calculate(kernel, (Dimensions)new FinalDimensions(paddedSize));
        RandomAccessibleInterval<C> fftImage = this.createOp.calculate((Dimensions)new FinalDimensions(paddedSize));
        RandomAccessibleInterval<C> fftKernel = this.createOp.calculate((Dimensions)new FinalDimensions(paddedSize));
        this.filter = this.createFilterComputer(paddedInput, paddedKernel, fftImage, fftKernel, output, (Interval)paddedInput);
        this.filter.compute(paddedInput, paddedKernel, output);
        return output;
    }

    public abstract BinaryComputerOp<RandomAccessibleInterval<I>, RandomAccessibleInterval<K>, RandomAccessibleInterval<O>> createFilterComputer(RandomAccessibleInterval<I> var1, RandomAccessibleInterval<K> var2, RandomAccessibleInterval<C> var3, RandomAccessibleInterval<C> var4, RandomAccessibleInterval<O> var5, Interval var6);

    protected long[] getBorderSize() {
        return this.borderSize;
    }

    protected OutOfBoundsFactory<I, RandomAccessibleInterval<I>> getOBFInput() {
        return this.obfInput;
    }

    protected void setOBFInput(OutOfBoundsFactory<I, RandomAccessibleInterval<I>> objInput) {
        this.obfInput = objInput;
    }

    protected OutOfBoundsFactory<K, RandomAccessibleInterval<K>> getOBFKernel() {
        return this.obfKernel;
    }

    protected void setOBFKernel(OutOfBoundsFactory<K, RandomAccessibleInterval<K>> obfKernel) {
        this.obfKernel = obfKernel;
    }

    protected Type<O> getOutType() {
        return this.outType;
    }
}

