/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops;

import net.imagej.ImageMetadata;
import net.imagej.ImgPlusMetadata;
import net.imagej.Sourced;
import net.imagej.axis.Axis;
import net.imagej.axis.CalibratedAxis;
import net.imagej.space.CalibratedSpace;
import net.imglib2.Interval;
import org.scijava.Named;

public class MetadataUtil {
    private MetadataUtil() {
    }

    public static Sourced copySource(Sourced in, Sourced out) {
        out.setSource(in.getSource());
        return out;
    }

    public static Named copyName(Named in, Named out) {
        out.setName(in.getName());
        return out;
    }

    public static ImageMetadata copyImageMetadata(ImageMetadata in, ImageMetadata out) {
        out.setValidBits(in.getValidBits());
        out.setCompositeChannelCount(in.getCompositeChannelCount());
        for (int c = 0; c < out.getCompositeChannelCount(); ++c) {
            out.setChannelMinimum(c, in.getChannelMinimum(c));
            out.setChannelMaximum(c, in.getChannelMaximum(c));
        }
        out.initializeColorTables(in.getColorTableCount());
        for (int n = 0; n < in.getColorTableCount(); ++n) {
            out.setColorTable(in.getColorTable(n), n);
        }
        return out;
    }

    public static <C extends CalibratedAxis> CalibratedSpace<C> copyTypedSpace(CalibratedSpace<C> in, CalibratedSpace<C> out) {
        MetadataUtil.copyTypedSpace(null, in, out);
        return out;
    }

    public static ImgPlusMetadata copyImgPlusMetadata(ImgPlusMetadata in, ImgPlusMetadata out) {
        MetadataUtil.copyName((Named)in, (Named)out);
        MetadataUtil.copySource((Sourced)in, (Sourced)out);
        MetadataUtil.copyImageMetadata((ImageMetadata)in, (ImageMetadata)out);
        MetadataUtil.copyTypedSpace(in, out);
        return out;
    }

    public static <C extends CalibratedAxis> CalibratedSpace<C> copyAndCleanTypedSpace(Interval inInterval, CalibratedSpace<C> in, CalibratedSpace<C> out) {
        MetadataUtil.copyTypedSpace(inInterval, in, out);
        return out;
    }

    public static ImgPlusMetadata copyAndCleanImgPlusMetadata(Interval inInterval, ImgPlusMetadata in, ImgPlusMetadata out) {
        MetadataUtil.copyName((Named)in, (Named)out);
        MetadataUtil.copySource((Sourced)in, (Sourced)out);
        MetadataUtil.copyImageMetadata((ImageMetadata)in, (ImageMetadata)out);
        MetadataUtil.copyAndCleanTypedSpace(inInterval, in, out);
        return out;
    }

    private static <C extends CalibratedAxis> void copyTypedSpace(Interval inInterval, CalibratedSpace<C> in, CalibratedSpace<C> out) {
        int offset = 0;
        for (int d = 0; d < in.numDimensions(); ++d) {
            if (inInterval != null && inInterval.dimension(d) == 1L) {
                ++offset;
                continue;
            }
            out.setAxis((Axis)((CalibratedAxis)in.axis(d)).copy(), d - offset);
        }
    }
}

