/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.notebook;

import com.twosigma.beaker.mimetype.MIMEContainer;
import java.util.Arrays;
import org.scijava.convert.ConvertService;
import org.scijava.log.LogService;
import org.scijava.notebook.NotebookService;
import org.scijava.notebook.converter.ouput.HTMLNotebookOutput;
import org.scijava.notebook.converter.ouput.LatexNotebookOutput;
import org.scijava.notebook.converter.ouput.MarkdownNotebookOutput;
import org.scijava.notebook.converter.ouput.NotebookOutput;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;

@Plugin(type=Service.class)
public class DefaultNotebookService
extends AbstractService
implements NotebookService {
    @Parameter
    private LogService log;
    @Parameter
    private ConvertService converService;

    @Override
    public Object display(Object object) {
        if (this.converService.supports(object, NotebookOutput.class)) {
            return this.converService.convert(object, NotebookOutput.class);
        }
        return object;
    }

    @Override
    public Object displayMimetype(String mimetype, String content) {
        MIMEContainer.MIME mimeTypeObj = Arrays.asList(MIMEContainer.MIME.values()).stream().filter(m -> m.getMime().equals(mimetype)).findFirst().orElse(null);
        if (mimeTypeObj == null) {
            this.log.warn("The mimetype '" + mimetype + "' is not supported");
            return content;
        }
        return new MIMEContainer(mimeTypeObj, content);
    }

    @Override
    public Object displayAsHTML(String content) {
        if (this.converService.supports((Object)content, HTMLNotebookOutput.class)) {
            return this.converService.convert((Object)content, HTMLNotebookOutput.class);
        }
        return content;
    }

    @Override
    public Object displayAsMarkdown(String content) {
        if (this.converService.supports((Object)content, MarkdownNotebookOutput.class)) {
            return this.converService.convert((Object)content, MarkdownNotebookOutput.class);
        }
        return content;
    }

    @Override
    public Object displayAsLatex(String content) {
        if (this.converService.supports((Object)content, LatexNotebookOutput.class)) {
            return this.converService.convert((Object)content, LatexNotebookOutput.class);
        }
        return content;
    }
}

