/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.tac.functions;

import com.google.common.collect.Maps;
import java.util.Map;
import org.renjin.compiler.ir.tac.functions.AndTranslator;
import org.renjin.compiler.ir.tac.functions.AssignLeftTranslator;
import org.renjin.compiler.ir.tac.functions.AssignTranslator;
import org.renjin.compiler.ir.tac.functions.BracketTranslator;
import org.renjin.compiler.ir.tac.functions.BreakTranslator;
import org.renjin.compiler.ir.tac.functions.ClosureTranslator;
import org.renjin.compiler.ir.tac.functions.DollarAssignTranslator;
import org.renjin.compiler.ir.tac.functions.DollarTranslator;
import org.renjin.compiler.ir.tac.functions.ForTranslator;
import org.renjin.compiler.ir.tac.functions.FunctionCallTranslator;
import org.renjin.compiler.ir.tac.functions.IfTranslator;
import org.renjin.compiler.ir.tac.functions.InternalCallTranslator;
import org.renjin.compiler.ir.tac.functions.NextTranslator;
import org.renjin.compiler.ir.tac.functions.OrTranslator;
import org.renjin.compiler.ir.tac.functions.ParenTranslator;
import org.renjin.compiler.ir.tac.functions.ReassignLeftTranslator;
import org.renjin.compiler.ir.tac.functions.RepeatTranslator;
import org.renjin.compiler.ir.tac.functions.SwitchTranslator;
import org.renjin.compiler.ir.tac.functions.WhileTranslator;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbol;

public class FunctionCallTranslators {
    private Map<Symbol, FunctionCallTranslator> builders = Maps.newIdentityHashMap();

    public FunctionCallTranslators() {
        this.builders.put(Symbol.get("if"), new IfTranslator());
        this.builders.put(Symbol.get("{"), new BracketTranslator());
        this.builders.put(Symbol.get("("), new ParenTranslator());
        this.builders.put(Symbol.get("<-"), new AssignLeftTranslator());
        this.builders.put(Symbol.get("<<-"), new ReassignLeftTranslator());
        this.builders.put(Symbol.get("="), new AssignTranslator());
        this.builders.put(Symbol.get("for"), new ForTranslator());
        this.builders.put(Symbol.get("repeat"), new RepeatTranslator());
        this.builders.put(Symbol.get("while"), new WhileTranslator());
        this.builders.put(Symbol.get("next"), new NextTranslator());
        this.builders.put(Symbol.get("break"), new BreakTranslator());
        this.builders.put(Symbol.get("function"), new ClosureTranslator());
        this.builders.put(Symbol.get("$"), new DollarTranslator());
        this.builders.put(Symbol.get("$<-"), new DollarAssignTranslator());
        this.builders.put(Symbol.get(".Internal"), new InternalCallTranslator());
        this.builders.put(Symbol.get("&&"), new AndTranslator());
        this.builders.put(Symbol.get("||"), new OrTranslator());
        this.builders.put(Symbol.get("switch"), new SwitchTranslator());
    }

    public FunctionCallTranslator get(SEXP function2) {
        if (function2 instanceof Symbol && this.builders.containsKey(function2)) {
            return this.builders.get(function2);
        }
        return null;
    }
}

