/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.topology.eulerCharacteristic;

import java.util.Arrays;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.BooleanType;
import net.imglib2.view.Views;

public class Octant<B extends BooleanType<B>> {
    private final boolean[] neighborhood = new boolean[8];
    private final RandomAccess<B> access;
    private int foregroundNeighbors;

    public Octant(RandomAccessibleInterval<B> interval) {
        this.access = Views.extendZero(interval).randomAccess();
    }

    public int getNeighborCount() {
        return this.foregroundNeighbors;
    }

    public boolean isNeighborForeground(int n) {
        return this.neighborhood[n - 1];
    }

    public boolean isNeighborhoodEmpty() {
        return this.foregroundNeighbors == 0;
    }

    public void setNeighborhood(long x, long y, long z) {
        Arrays.fill(this.neighborhood, false);
        this.neighborhood[0] = this.getAtLocation(this.access, x - 1L, y - 1L, z - 1L);
        this.neighborhood[1] = this.getAtLocation(this.access, x - 1L, y, z - 1L);
        this.neighborhood[2] = this.getAtLocation(this.access, x, y - 1L, z - 1L);
        this.neighborhood[3] = this.getAtLocation(this.access, x, y, z - 1L);
        this.neighborhood[4] = this.getAtLocation(this.access, x - 1L, y - 1L, z);
        this.neighborhood[5] = this.getAtLocation(this.access, x - 1L, y, z);
        this.neighborhood[6] = this.getAtLocation(this.access, x, y - 1L, z);
        this.neighborhood[7] = this.getAtLocation(this.access, x, y, z);
        this.countForegroundNeighbors();
    }

    private void countForegroundNeighbors() {
        this.foregroundNeighbors = 0;
        for (boolean neighbor : this.neighborhood) {
            if (!neighbor) continue;
            ++this.foregroundNeighbors;
        }
    }

    private boolean getAtLocation(RandomAccess<B> access, long x, long y, long z) {
        access.setPosition(x, 0);
        access.setPosition(y, 1);
        access.setPosition(z, 2);
        return ((BooleanType)access.get()).get();
    }
}

