/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.threshold.intermodes;

import net.imagej.ops.Ops;
import net.imagej.ops.threshold.AbstractComputeThresholdHistogram;
import net.imagej.ops.threshold.Thresholds;
import net.imglib2.histogram.Histogram1d;
import net.imglib2.type.numeric.RealType;
import org.scijava.ItemIO;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Threshold.Intermodes.class, priority=100.0)
public class ComputeIntermodesThreshold<T extends RealType<T>>
extends AbstractComputeThresholdHistogram<T>
implements Ops.Threshold.Intermodes {
    @Parameter(type=ItemIO.OUTPUT)
    private String errMsg = null;

    @Override
    public long computeBin(Histogram1d<T> hist) {
        long[] histogram = hist.toLongArray();
        double[] iHisto = new double[histogram.length];
        int iter = 0;
        int threshold = -1;
        for (int i = 0; i < histogram.length; ++i) {
            iHisto[i] = histogram[i];
        }
        while (!Thresholds.bimodalTest(iHisto)) {
            double previous = 0.0;
            double current = 0.0;
            double next = iHisto[0];
            for (int i = 0; i < histogram.length - 1; ++i) {
                previous = current;
                current = next;
                next = iHisto[i + 1];
                iHisto[i] = (previous + current + next) / 3.0;
            }
            iHisto[histogram.length - 1] = (current + next) / 3.0;
            if (++iter <= 10000) continue;
            this.errMsg = "Intermodes Threshold not found after 10000 iterations.";
            return -1L;
        }
        int tt = 0;
        for (int i = 1; i < histogram.length - 1; ++i) {
            if (!(iHisto[i - 1] < iHisto[i]) || !(iHisto[i + 1] < iHisto[i])) continue;
            tt += i;
        }
        threshold = (int)Math.floor((double)tt / 2.0);
        return threshold;
    }
}

