/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.stats;

import net.imagej.ops.Ops;
import net.imagej.ops.special.chain.RTs;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imagej.ops.stats.AbstractStatsOp;
import net.imglib2.type.numeric.RealType;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Stats.Skewness.class, label="Statistics: Skewness")
public class DefaultSkewness<I extends RealType<I>, O extends RealType<O>>
extends AbstractStatsOp<Iterable<I>, O>
implements Ops.Stats.Skewness {
    private UnaryFunctionOp<Iterable<I>, O> moment3AboutMeanFunc;
    private UnaryFunctionOp<Iterable<I>, O> stdDevFunc;

    @Override
    public void initialize() {
        this.moment3AboutMeanFunc = RTs.function(this.ops(), Ops.Stats.Moment3AboutMean.class, this.in(), new Object[0]);
        this.stdDevFunc = RTs.function(this.ops(), Ops.Stats.StdDev.class, this.in(), new Object[0]);
    }

    @Override
    public void compute(Iterable<I> input, O output) {
        double moment3 = ((RealType)this.moment3AboutMeanFunc.calculate(input)).getRealDouble();
        double std = ((RealType)this.stdDevFunc.calculate(input)).getRealDouble();
        output.setReal(Double.NaN);
        if (std != 0.0) {
            output.setReal(moment3 / (std * std * std));
        }
    }
}

