/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.image.ascii;

import net.imagej.ops.Ops;
import net.imagej.ops.special.function.AbstractUnaryFunctionOp;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Pair;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Image.ASCII.class)
public class DefaultASCII<T extends RealType<T>>
extends AbstractUnaryFunctionOp<IterableInterval<T>, String>
implements Ops.Image.ASCII {
    private static final String CHARS = "#O*o+-,. ";
    @Parameter(required=false)
    private T min;
    @Parameter(required=false)
    private T max;
    private UnaryFunctionOp<IterableInterval<T>, Pair<T, T>> minMaxFunc;

    @Override
    public void initialize() {
        this.minMaxFunc = Functions.unary(this.ops(), Ops.Stats.MinMax.class, Pair.class, this.in(), new Object[0]);
    }

    @Override
    public String calculate(IterableInterval<T> input) {
        if (this.min == null || this.max == null) {
            Pair<T, T> minMax = this.minMaxFunc.calculate(input);
            if (this.min == null) {
                this.min = (RealType)minMax.getA();
            }
            if (this.max == null) {
                this.max = (RealType)minMax.getB();
            }
        }
        return DefaultASCII.ascii(input, this.min, this.max);
    }

    public static <T extends RealType<T>> String ascii(IterableInterval<T> image, T min, T max) {
        long dim0 = image.dimension(0);
        long dim1 = image.dimension(1);
        int w = (int)(dim0 + 1L);
        int h = (int)dim1;
        RealType span = (RealType)max.copy();
        span.sub(min);
        char[] c = new char[w * h];
        for (int y = 1; y <= h; ++y) {
            c[w * y - 1] = 10;
        }
        Cursor cursor = image.localizingCursor();
        int[] pos = new int[image.numDimensions()];
        RealType tmp = (RealType)((RealType)image.firstElement()).copy();
        while (cursor.hasNext()) {
            cursor.fwd();
            cursor.localize(pos);
            int index = w * pos[1] + pos[0];
            tmp.set((Type)cursor.get());
            tmp.sub(min);
            double normalized = tmp.getRealDouble() / span.getRealDouble();
            int charLen = CHARS.length();
            int charIndex = (int)((double)charLen * normalized);
            c[index] = CHARS.charAt(charIndex < charLen ? charIndex : charLen - 1);
        }
        return new String(c);
    }
}

