/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.geom.geom3d.mesh;

import java.lang.reflect.Type;
import net.imagej.ops.OpEnvironment;
import net.imagej.ops.OpService;
import net.imagej.ops.Ops;
import net.imagej.ops.geom.geom3d.mesh.Mesh;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessibleInterval;
import org.scijava.convert.AbstractConverter;
import org.scijava.convert.ConversionRequest;
import org.scijava.convert.Converter;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Converter.class, priority=10000.0)
public class RAIToMeshConverter
extends AbstractConverter<RandomAccessibleInterval, Mesh> {
    @Parameter(required=false)
    private OpService ops;
    private UnaryFunctionOp<RandomAccessibleInterval, Mesh> marchingCubesFunc;

    public <T> T convert(Object src, Class<T> dest) {
        if (this.marchingCubesFunc == null) {
            this.marchingCubesFunc = Functions.unary((OpEnvironment)this.ops, Ops.Geometric.MarchingCubes.class, Mesh.class, (RandomAccessibleInterval)src, new Object[0]);
        }
        if (src instanceof IterableInterval) {
            return (T)this.marchingCubesFunc.calculate((RandomAccessibleInterval)src);
        }
        return null;
    }

    public Class<Mesh> getOutputType() {
        return Mesh.class;
    }

    public Class<RandomAccessibleInterval> getInputType() {
        return RandomAccessibleInterval.class;
    }

    public boolean supports(ConversionRequest request) {
        if (this.ops == null) {
            return false;
        }
        Object sourceObject = request.sourceObject();
        if (sourceObject == null || !(sourceObject instanceof RandomAccessibleInterval)) {
            return false;
        }
        if (((RandomAccessibleInterval)sourceObject).numDimensions() != 3) {
            return false;
        }
        Class destClass = request.destClass();
        Type destType = request.destType();
        if (destClass != null && destClass != Mesh.class) {
            return false;
        }
        return destType == null || destType == Mesh.class;
    }
}

