/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.HeadlessException;
import java.awt.event.KeyListener;
import javax.swing.JFrame;
import org.scijava.ui.ApplicationFrame;
import org.scijava.ui.awt.AWTInputEventDispatcher;

public class SwingApplicationFrame
extends JFrame
implements ApplicationFrame {
    public SwingApplicationFrame(String title) throws HeadlessException {
        super(title);
    }

    public void addEventDispatcher(AWTInputEventDispatcher dispatcher) {
        dispatcher.register((Component)this, false, true);
        this.addKeyDispatcher(dispatcher, this.getContentPane());
    }

    public int getLocationX() {
        return this.getLocation().x;
    }

    public int getLocationY() {
        return this.getLocation().y;
    }

    public void activate() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingApplicationFrame.this.toFront();
                SwingApplicationFrame.this.repaint();
            }
        });
    }

    private void addKeyDispatcher(AWTInputEventDispatcher dispatcher, Component comp) {
        comp.addKeyListener((KeyListener)dispatcher);
        if (!(comp instanceof Container)) {
            return;
        }
        Container c = (Container)comp;
        int childCount = c.getComponentCount();
        for (int i = 0; i < childCount; ++i) {
            Component child = c.getComponent(i);
            this.addKeyDispatcher(dispatcher, child);
        }
    }
}

