/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.script;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import org.scijava.Context;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.script.ScriptREPL;
import org.scijava.ui.swing.script.DefaultAutoImporters;
import org.scijava.ui.swing.script.OutputPane;
import org.scijava.ui.swing.script.PromptPane;
import org.scijava.ui.swing.script.VarsPane;
import org.scijava.widget.UIComponent;

public class InterpreterPane
implements UIComponent<JComponent> {
    private final ScriptREPL repl;
    private final JSplitPane mainPane;
    private final OutputPane output;
    private final PromptPane prompt;
    private final VarsPane vars;
    @Parameter(required=false)
    private LogService log;

    public InterpreterPane(Context context) {
        context.inject(this);
        this.output = new OutputPane(this.log);
        JScrollPane outputScroll = new JScrollPane(this.output);
        outputScroll.setPreferredSize(new Dimension(440, 400));
        this.repl = new ScriptREPL(context, this.output.getOutputStream());
        this.repl.initialize();
        Writer writer = this.output.getOutputWriter();
        ScriptContext ctx = this.repl.getInterpreter().getEngine().getContext();
        ctx.setErrorWriter(writer);
        ctx.setWriter(writer);
        this.vars = new VarsPane(context, this.repl);
        this.vars.setBorder(new EmptyBorder(0, 0, 8, 0));
        this.prompt = new PromptPane(this.repl, this.vars, this.output){

            @Override
            public void quit() {
                InterpreterPane.this.dispose();
            }
        };
        JScrollPane promptScroll = new JScrollPane(this.prompt.getComponent());
        JButton clearButton = new JButton("Clear");
        clearButton.setToolTipText("Clears the text in the output pane.");
        clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InterpreterPane.this.output.setText("");
            }
        });
        JPanel bottomPane = new JPanel();
        bottomPane.setLayout((LayoutManager)new MigLayout("", "[grow,fill][pref]", "[grow,fill,align top]"));
        bottomPane.add((Component)promptScroll, "spany 2");
        bottomPane.add((Component)clearButton, "w pref!, h pref!, wrap");
        final Object importGenerator = DefaultAutoImporters.getImportGenerator(this.log.getContext(), this.repl.getInterpreter().getLanguage());
        if (importGenerator != null) {
            final JButton autoImportButton = new JButton("Auto-Import");
            autoImportButton.setToolTipText("Auto-imports common classes.");
            autoImportButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        InterpreterPane.this.repl.getInterpreter().getEngine().eval(importGenerator.toString());
                    }
                    catch (ScriptException e1) {
                        e1.printStackTrace(new PrintWriter(InterpreterPane.this.output.getOutputWriter()));
                    }
                    autoImportButton.setEnabled(false);
                    InterpreterPane.this.prompt.getComponent().requestFocus();
                }
            });
            bottomPane.add((Component)autoImportButton, "w pref!, h pref!, wrap");
        }
        JSplitPane outputAndPromptPane = new JSplitPane(0, outputScroll, bottomPane);
        outputAndPromptPane.setResizeWeight(1.0);
        this.mainPane = new JSplitPane(1, this.vars, outputAndPromptPane);
        this.mainPane.setDividerLocation(300);
    }

    public ScriptREPL getREPL() {
        return this.repl;
    }

    public void print(String string) {
        Writer writer = this.output.getOutputWriter();
        try {
            writer.write(string + "\n");
        }
        catch (IOException e) {
            e.printStackTrace(new PrintWriter(writer));
        }
    }

    public void dispose() {
        this.output.close();
    }

    @Override
    public JComponent getComponent() {
        return this.mainPane;
    }

    @Override
    public Class<JComponent> getComponentType() {
        return JComponent.class;
    }
}

