/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.io;

import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.LinkedList;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.filechooser.FileFilter;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.ImageHolderFigure;
import org.jhotdraw.draw.io.InputFormat;
import org.jhotdraw.gui.filechooser.ExtensionFileFilter;
import org.jhotdraw.util.Images;

public class ImageInputFormat
implements InputFormat {
    private ImageHolderFigure prototype;
    private String description;
    private String[] fileExtensions;
    private String formatName;
    private String[] mimeTypes;

    public ImageInputFormat(ImageHolderFigure prototype) {
        this(prototype, "Image", "Image", ImageIO.getReaderFileSuffixes(), ImageIO.getReaderMIMETypes());
    }

    public ImageInputFormat(ImageHolderFigure prototype, String formatName, String description, String fileExtension, String mimeType) {
        this(prototype, formatName, description, new String[]{fileExtension}, new String[]{mimeType});
    }

    public ImageInputFormat(ImageHolderFigure prototype, String formatName, String description, String[] fileExtensions, String[] mimeTypes) {
        this.prototype = prototype;
        this.formatName = formatName;
        this.description = description;
        this.fileExtensions = (String[])fileExtensions.clone();
        this.mimeTypes = (String[])mimeTypes.clone();
    }

    @Override
    public FileFilter getFileFilter() {
        return new ExtensionFileFilter(this.description, this.fileExtensions);
    }

    public String[] getFileExtensions() {
        return (String[])this.fileExtensions.clone();
    }

    @Override
    public JComponent getInputFormatAccessory() {
        return null;
    }

    @Override
    public void read(URI uri, Drawing drawing) throws IOException {
        this.read(new File(uri), drawing);
    }

    @Override
    public void read(URI uri, Drawing drawing, boolean replace) throws IOException {
        this.read(new File(uri), drawing, replace);
    }

    public void read(File file, Drawing drawing, boolean replace) throws IOException {
        ImageHolderFigure figure = (ImageHolderFigure)this.prototype.clone();
        figure.loadImage(file);
        figure.setBounds(new Point2D.Double(0.0, 0.0), new Point2D.Double(figure.getBufferedImage().getWidth(), figure.getBufferedImage().getHeight()));
        if (replace) {
            drawing.removeAllChildren();
            drawing.set(AttributeKeys.CANVAS_WIDTH, figure.getBounds().width);
            drawing.set(AttributeKeys.CANVAS_HEIGHT, figure.getBounds().height);
        }
        drawing.basicAdd(figure);
    }

    public void read(File file, Drawing drawing) throws IOException {
        this.read(file, drawing, true);
    }

    @Override
    public void read(InputStream in, Drawing drawing, boolean replace) throws IOException {
        ImageHolderFigure figure = this.createImageHolder(in);
        if (replace) {
            drawing.removeAllChildren();
            drawing.set(AttributeKeys.CANVAS_WIDTH, figure.getBounds().width);
            drawing.set(AttributeKeys.CANVAS_HEIGHT, figure.getBounds().height);
        }
        drawing.basicAdd(figure);
    }

    public ImageHolderFigure createImageHolder(InputStream in) throws IOException {
        ImageHolderFigure figure = (ImageHolderFigure)this.prototype.clone();
        figure.loadImage(in);
        figure.setBounds(new Point2D.Double(0.0, 0.0), new Point2D.Double(figure.getBufferedImage().getWidth(), figure.getBufferedImage().getHeight()));
        return figure;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        if (DataFlavor.imageFlavor.match(flavor)) {
            return true;
        }
        for (String mimeType : this.mimeTypes) {
            if (!flavor.isMimeTypeEqual(mimeType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void read(Transferable t, Drawing drawing, boolean replace) throws UnsupportedFlavorException, IOException {
        DataFlavor importFlavor = null;
        block0: for (DataFlavor flavor : t.getTransferDataFlavors()) {
            if (DataFlavor.imageFlavor.match(flavor)) {
                importFlavor = flavor;
                break;
            }
            for (String mimeType : this.mimeTypes) {
                if (!flavor.isMimeTypeEqual(mimeType)) continue;
                importFlavor = flavor;
                break block0;
            }
        }
        Object data = t.getTransferData(importFlavor);
        Image img = null;
        if (data instanceof Image) {
            img = (Image)data;
        } else if (data instanceof InputStream) {
            img = ImageIO.read((InputStream)data);
        }
        if (img == null) {
            throw new IOException("Unsupported data format " + importFlavor);
        }
        ImageHolderFigure figure = (ImageHolderFigure)this.prototype.clone();
        figure.setBufferedImage(Images.toBufferedImage(img));
        figure.setBounds(new Point2D.Double(0.0, 0.0), new Point2D.Double(figure.getBufferedImage().getWidth(), figure.getBufferedImage().getHeight()));
        LinkedList<ImageHolderFigure> list = new LinkedList<ImageHolderFigure>();
        list.add(figure);
        if (replace) {
            drawing.removeAllChildren();
            drawing.set(AttributeKeys.CANVAS_WIDTH, figure.getBounds().width);
            drawing.set(AttributeKeys.CANVAS_HEIGHT, figure.getBounds().height);
        }
        drawing.addAll(list);
    }
}

