/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beaker.jvm.serialization;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twosigma.beaker.jvm.serialization.BeakerObjectConverter;
import com.twosigma.beaker.jvm.serialization.ObjectDeserializer;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionDeserializer
implements ObjectDeserializer {
    private static final Logger logger = LoggerFactory.getLogger((String)CollectionDeserializer.class.getName());
    private final BeakerObjectConverter parent;

    public CollectionDeserializer(BeakerObjectConverter p) {
        this.parent = p;
    }

    @Override
    public boolean canBeUsed(JsonNode n) {
        return n.isArray();
    }

    @Override
    public Object deserialize(JsonNode n, ObjectMapper mapper) {
        ArrayList<Object> o = new ArrayList<Object>();
        try {
            logger.debug("using custom array deserializer");
            for (int i = 0; i < n.size(); ++i) {
                o.add(this.parent.deserialize(n.get(i), mapper));
            }
        }
        catch (Exception e) {
            logger.error("exception deserializing Collection ", (Throwable)e);
            o = null;
        }
        return o;
    }
}

