/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beaker.jupyter.handler;

import com.twosigma.beaker.jupyter.comm.Comm;
import com.twosigma.beaker.jupyter.msg.JupyterMessages;
import com.twosigma.jupyter.KernelFunctionality;
import com.twosigma.jupyter.handler.Handler;
import com.twosigma.jupyter.handler.KernelHandler;
import com.twosigma.jupyter.handler.KernelHandlerWrapper;
import com.twosigma.jupyter.message.Header;
import com.twosigma.jupyter.message.Message;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommOpenHandler
extends KernelHandler<Message> {
    private static final Logger logger = LoggerFactory.getLogger(CommOpenHandler.class);

    public CommOpenHandler(KernelFunctionality kernel) {
        super(kernel);
    }

    @Override
    public void handle(Message message) {
        KernelHandlerWrapper.wrapBusyIdle(this.kernel, message, () -> this.handleMsg(message));
    }

    private void handleMsg(Message message) {
        logger.debug("Processing CommOpenHandler");
        Message reply = new Message();
        HashMap<String, Serializable> map = new HashMap<String, Serializable>(6);
        Map<String, Serializable> commMap = message.getContent();
        Comm newComm = null;
        if (this.isValidMessage(commMap)) {
            newComm = this.readComm(commMap);
            reply.setHeader(new Header(JupyterMessages.COMM_OPEN, message.getHeader().getSession()));
            map.put("comm_id", (Serializable)((Object)newComm.getCommId()));
            map.put("target_name", (Serializable)((Object)newComm.getTargetName()));
            map.put("data", new HashMap());
            map.put("target_module", (Serializable)((Object)newComm.getTargetModule()));
        } else {
            reply.setHeader(new Header(JupyterMessages.COMM_CLOSE, message.getHeader().getSession()));
            map.put("data", new HashMap());
        }
        if (newComm != null) {
            logger.debug("Comm opened, target name = " + newComm.getTargetName());
            for (Handler<Message> handler : this.getKernelControlChanelHandlers(newComm.getTargetName())) {
                newComm.addMsgCallbackList(handler);
            }
            this.kernel.addComm(newComm.getCommId(), newComm);
        }
        reply.setContent(map);
        reply.setParentHeader(message.getHeader());
        reply.setIdentities(message.getIdentities());
        this.send(reply);
    }

    public abstract Handler<Message>[] getKernelControlChanelHandlers(String var1);

    public static String getString(Map<String, Serializable> map, String name) {
        return (String)((Object)map.get(name));
    }

    protected Comm readComm(Map<String, Serializable> map) {
        Comm ret = new Comm(CommOpenHandler.getString(map, "comm_id"), CommOpenHandler.getString(map, "target_name"));
        ret.setData((HashMap)map.get("data"));
        ret.setTargetModule(CommOpenHandler.getString(map, "target_module"));
        return ret;
    }

    protected boolean isValidMessage(Map<String, Serializable> map) {
        boolean ret = true;
        ret = ret && map.get("comm_id") != null && map.get("comm_id") instanceof String;
        ret = ret && map.get("target_name") != null && map.get("target_name") instanceof String;
        ret = ret && !this.kernel.isCommPresent(CommOpenHandler.getString(map, "comm_id"));
        return ret;
    }
}

