/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beaker.jupyter.handler;

import com.twosigma.beaker.jupyter.comm.Comm;
import com.twosigma.beaker.jupyter.msg.JupyterMessages;
import com.twosigma.jupyter.KernelFunctionality;
import com.twosigma.jupyter.handler.KernelHandler;
import com.twosigma.jupyter.handler.KernelHandlerWrapper;
import com.twosigma.jupyter.message.Header;
import com.twosigma.jupyter.message.Message;
import java.io.Serializable;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommInfoHandler
extends KernelHandler<Message> {
    private static final Logger logger = LoggerFactory.getLogger(CommInfoHandler.class);

    public CommInfoHandler(KernelFunctionality kernel) {
        super(kernel);
    }

    @Override
    public void handle(Message message) {
        KernelHandlerWrapper.wrapBusyIdle(this.kernel, message, () -> this.handleMsg(message));
    }

    private void handleMsg(Message message) {
        logger.debug("Processing CommInfoHandler");
        Message reply = new Message();
        reply.setHeader(new Header(JupyterMessages.COMM_INFO_REPLY, message.getHeader().getSession()));
        HashMap<String, Serializable> content = new HashMap<String, Serializable>();
        content.put("comms", new HashMap());
        for (String commHash : this.kernel.getCommHashSet()) {
            HashMap<String, String> commRepDetails = new HashMap<String, String>();
            Comm comm = this.kernel.getComm(commHash);
            commRepDetails.put("target_name", comm.getTargetName());
            ((HashMap)content.get("comms")).put(comm.getCommId(), commRepDetails);
        }
        reply.setContent(content);
        reply.setParentHeader(message.getHeader());
        reply.setIdentities(message.getIdentities());
        this.send(reply);
    }
}

