/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beaker.jupyter;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.TimeZone;
import java.util.UUID;

public class Utils {
    public static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    public static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mmZ";
    public static final String EMPTY_STRING = "";

    public static String timestamp() {
        SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
        df.setTimeZone(UTC);
        return df.format(new Date());
    }

    public static String uuid() {
        return UUID.randomUUID().toString();
    }

    public static String getUsString(String[] input) {
        StringBuilder ret = new StringBuilder();
        if (input != null && input.length > 0) {
            for (String s : input) {
                ret.append(s + "\n");
            }
        }
        return ret.toString();
    }

    public static String getAsString(Collection<String> input) {
        if (input == null || input.isEmpty()) {
            return EMPTY_STRING;
        }
        return Utils.getUsString(input.toArray(new String[input.size()]));
    }
}

